# 通知設計書 71-Windows 7互換性警告

## 概要

本ドキュメントは、StaxRipアプリケーションにおけるWindows 7環境での互換性問題を警告する通知の設計仕様を定義する。

### 本通知の処理概要

本通知は、Windows 7環境でStaxRipを実行する際に、一部のツールが正常に動作しない可能性があることをユーザーに警告するために使用される。

**業務上の目的・背景**：Windows 7はStaxRip自体ではサポートされているが、依存する一部の外部ツール（MKVToolNix、Python等）がWindows 7をサポートしなくなっている。このため、ユーザーがWindows 7環境で予期せぬエラーに遭遇する前に、事前に互換性の問題を周知し、必要な対策（ツールのダウングレードや代替手段の検討）を促す必要がある。

**通知の送信タイミング**：StaxRipのメインフォームが表示された後、アプリケーション起動時に一度だけ表示される。具体的には、`s.ShowWindows7Warning`フラグがTrue、かつOSのメジャーバージョンが7の場合にトリガーされる。

**通知の受信者**：Windows 7環境でStaxRipを起動したエンドユーザー。

**通知内容の概要**：「Compatibility problem!」というタイトルで、Windows 7環境における特定ツールの互換性問題について説明し、影響を受けるツール（MKVToolNix、Python）を具体的に列挙し、対策方法（ダウングレードまたは回避）とDiscordサーバーへの参加を案内する。

**期待されるアクション**：ユーザーは警告内容を理解し、必要に応じてMKVToolNixやPythonをダウングレードするか、これらのツールの使用を避ける。また、問題が発生した場合はDiscordサーバーで支援を求める。

## 通知種別

アプリ内通知（タスクダイアログ）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期 |
| 優先度 | 高 |
| リトライ | 無 |

### 送信先決定ロジック

Windows 7環境（OSVersion.VersionInfo.dwMajorVersion = 7）でアプリケーションを実行しているすべてのユーザーに対して表示される。初回起動時のみ表示され、一度表示後は`s.ShowWindows7Warning`フラグがFalseに設定されるため、再表示されない。

## 通知テンプレート

### タスクダイアログ通知

| 項目 | 内容 |
|-----|------|
| アイコン | 警告（Warning） |
| タイトル | Compatibility problem! |
| ボタン | OK |

### 本文テンプレート

```
Whereas Windows 7 is supported by StaxRip itself, some tools don't do it anymore. This can cause tools denying to work correctly or at whole. Currently those tools are 'MKVToolNix (mkvmerge)' and 'Python', which you have to downgrade or try to avoid. For further help join our Discord server.
```

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| N/A | - | - | 添付ファイルなし |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| N/A | 固定メッセージのため変数なし | - | - |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| アプリケーション起動 | MainForm表示後 | s.ShowWindows7Warning = True かつ OSVersion.VersionInfo.dwMajorVersion = 7 | 初回起動時のみ |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| s.ShowWindows7Warning = False | 既に警告表示済みの場合 |
| OSVersion.VersionInfo.dwMajorVersion <> 7 | Windows 7以外のOS |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[アプリケーション起動] --> B{s.ShowWindows7Warning?}
    B -->|False| C[警告スキップ]
    B -->|True| D{OSメジャーバージョン = 7?}
    D -->|No| C
    D -->|Yes| E[MsgWarn呼び出し]
    E --> F[タスクダイアログ表示]
    F --> G[ユーザーOKクリック]
    G --> H[s.ShowWindows7Warning = False設定]
    H --> I[終了]
    C --> I
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| N/A | データベース不使用 | 設定ファイルベース |

### テーブル別参照項目詳細

データベースは使用せず、アプリケーション設定（sオブジェクト）を参照する。

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| N/A | - | 設定ファイルへの書き込み |

#### 設定更新

| 操作 | 項目 | 更新値 | 備考 |
|-----|------|-------|------|
| UPDATE | s.ShowWindows7Warning | False | 警告表示後に設定 |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| N/A | 同期ダイアログのため通常エラーなし | - |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 1回（初回起動時のみ） |

### 配信時間帯

制限なし（アプリケーション起動時に即座に表示）

## セキュリティ考慮事項

- 個人情報の取り扱い：なし
- 暗号化：不要
- 認証：不要

## 備考

- Windows 7のサポートは限定的であり、将来的に完全に廃止される可能性がある
- 影響を受けるツール（MKVToolNix、Python）は将来のバージョンで変更される可能性がある
- Discordサーバーへの誘導により、コミュニティサポートを活用できる

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

通知に関連する設定構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Settings.vb | `Source/General/Settings.vb` | ShowWindows7Warning設定プロパティの定義 |

**読解のコツ**: VB.NETのプロパティ定義と設定の永続化方法を確認する。

#### Step 2: エントリーポイントを理解する

処理の起点となるファイル・関数を特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | MainForm.vb | `Source/Forms/MainForm.vb` | CheckForWindows7メソッドの呼び出し元を特定 |

**主要処理フロー**:
1. **行6087-6092**: CheckForWindows7サブルーチン定義
2. **行6088**: s.ShowWindows7Warning と OSメジャーバージョンの条件判定
3. **行6089**: MsgWarn呼び出しで警告ダイアログ表示
4. **行6091**: ShowWindows7Warningフラグをfalseに設定

#### Step 3: 通知表示処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | General.vb | `Source/General/General.vb` | MsgWarnメソッドの実装（行1245） |

**主要処理フロー**:
- **行1245-1252**: MsgWarnメソッドがタスクダイアログを表示

### プログラム呼び出し階層図

```
MainForm.OnShown / OnActivated
    │
    └─ CheckForWindows7()
           │
           ├─ 条件チェック: s.ShowWindows7Warning AndAlso OSVersion = 7
           │
           └─ MsgWarn("Compatibility problem!", ...)
                  │
                  └─ Msg(title, content, TaskIcon.Warning, TaskButton.OK)
                         │
                         └─ TaskDialog.Show()
```

### データフロー図

```
[入力]               [処理]                    [出力]

s.ShowWindows7Warning ───▶ CheckForWindows7() ───▶ タスクダイアログ表示
OSVersion.VersionInfo ───▶                    ───▶ s.ShowWindows7Warning = False
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| MainForm.vb | `Source/Forms/MainForm.vb` | ソース | 通知トリガーの起点、CheckForWindows7メソッド定義 |
| General.vb | `Source/General/General.vb` | ソース | MsgWarn関数の定義 |
| Settings.vb | `Source/General/Settings.vb` | ソース | ShowWindows7Warning設定の定義 |
| TaskDialog.vb | `Source/UI/TaskDialog.vb` | ソース | タスクダイアログUIコンポーネント |
