# 通知設計書 72-ツール全正常通知

## 概要

本ドキュメントは、StaxRipアプリケーションのAppsForm画面において、すべてのツールが正常状態であることを確認した際に表示される情報通知の設計仕様を定義する。

### 本通知の処理概要

本通知は、AppsForm画面でユーザーが「Check All」機能を実行した結果、登録されているすべてのツールが正常なステータスであった場合に表示される。これにより、ユーザーは動画エンコード作業に必要なすべての外部ツールが適切に設定されていることを確認できる。

**業務上の目的・背景**：StaxRipは多数の外部ツール（エンコーダ、デマクサ、フィルタプラグイン等）に依存している。ユーザーが安心して動画処理を開始できるよう、すべてのツールが正常に検出・設定されていることを明確に通知する必要がある。問題がないことを積極的に伝えることで、ユーザーの不安を解消し、作業効率を向上させる。

**通知の送信タイミング**：AppsForm画面の「Tools」メニューから「Check All」（Ctrl+S）を選択した際、すべてのツールのステータスチェックが完了し、問題がない場合に表示される。

**通知の受信者**：AppsForm画面で「Check All」機能を実行したユーザー。

**通知内容の概要**：「OK!」というタイトルと「All tools have OK status!」という本文で、すべてのツールが正常であることを簡潔に伝える。

**期待されるアクション**：ユーザーはすべてのツールが正常であることを確認し、安心して動画処理作業を続行する。OKボタンをクリックしてダイアログを閉じる。

## 通知種別

アプリ内通知（タスクダイアログ）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期 |
| 優先度 | 中 |
| リトライ | 無 |

### 送信先決定ロジック

AppsForm画面で「Check All」を実行し、Package.Items内のすべてのパッケージのGetStatusが空文字列を返した場合（問題なし）に表示される。一つでも問題のあるツールがある場合は、代わりにそれらのツールの一覧が表示される。

## 通知テンプレート

### タスクダイアログ通知

| 項目 | 内容 |
|-----|------|
| アイコン | 情報（Info） |
| タイトル | OK! |
| ボタン | OK |

### 本文テンプレート

```
All tools have OK status!
```

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| N/A | - | - | 添付ファイルなし |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| N/A | 固定メッセージのため変数なし | - | - |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 画面操作 | miStatus.Clickイベント（Check All） | すべてのツールのGetStatus = "" | Ctrl+Sショートカットでも実行可能 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| 1つ以上のツールに問題がある | GetStatusが空でないツールが存在する場合、問題リストが表示される |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[ユーザーがCheck Allを選択] --> B[Package.Itemsをループ]
    B --> C{pack.GetStatus = ""?}
    C -->|No| D[txtに問題追加、counter++]
    C -->|Yes| E[次のパッケージへ]
    D --> E
    E --> F{全パッケージ処理完了?}
    F -->|No| B
    F -->|Yes| G{txt = ""?}
    G -->|Yes| H[MsgInfo OK! All tools have OK status!]
    G -->|No| I[MsgInfo counter apps found! txt]
    H --> J[終了]
    I --> J
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| N/A | データベース不使用 | メモリ上のPackage.Itemsを参照 |

### テーブル別参照項目詳細

Package.Items（Dictionary）内の各Packageオブジェクトに対してGetStatusメソッドを呼び出す。

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| N/A | - | 更新処理なし |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| N/A | 同期ダイアログのため通常エラーなし | - |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし（ユーザー操作に応じて即座に表示）

## セキュリティ考慮事項

- 個人情報の取り扱い：なし
- 暗号化：不要
- 認証：不要

## 備考

- この通知は「All required tools have OK status!」（必須ツールのみチェック）とは異なる
- ツールの状態は実行時に動的にチェックされる
- GetStatusメソッドはファイルの存在確認やバージョンチェックを含む

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

パッケージ管理の構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Package.vb | `Source/General/Package.vb` | Package.Itemsの定義とGetStatusメソッド |

**読解のコツ**: PackageクラスのGetStatusメソッドがどのような条件で空文字列/非空文字列を返すかを確認する。

#### Step 2: エントリーポイントを理解する

処理の起点となるファイル・関数を特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | AppsForm.vb | `Source/Forms/AppsForm.vb` | miStatus_Clickイベントハンドラ |

**主要処理フロー**:
1. **行900**: miStatus_Clickサブルーチン開始
2. **行901-902**: counter変数とtxt変数の初期化
3. **行904-911**: Package.Itemsをループし、GetStatusが空でないものを収集
4. **行913-917**: txtが空なら「All tools have OK status!」を表示

#### Step 3: 通知表示処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | General.vb | `Source/General/General.vb` | MsgInfoメソッドの実装（行1216） |

**主要処理フロー**:
- **行1216-1220**: MsgInfoメソッドがTaskIcon.Infoでタスクダイアログを表示

### プログラム呼び出し階層図

```
AppsForm.miStatus_Click
    │
    ├─ For Each pair In Package.Items
    │      │
    │      └─ pack.GetStatus()
    │             │
    │             └─ ステータス文字列を返却
    │
    └─ MsgInfo("OK!", "All tools have OK status!")
           │
           └─ Msg(title, content, TaskIcon.Info, TaskButton.OK)
                  │
                  └─ TaskDialog.Show()
```

### データフロー図

```
[入力]               [処理]                    [出力]

Package.Items ───▶ miStatus_Click() ───▶ タスクダイアログ表示
                       │
                       ├─ GetStatus() × N
                       │
                       └─ txt = "" 判定
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| AppsForm.vb | `Source/Forms/AppsForm.vb` | ソース | miStatus_Clickイベントハンドラ（行900-918） |
| General.vb | `Source/General/General.vb` | ソース | MsgInfo関数の定義（行1216） |
| Package.vb | `Source/General/Package.vb` | ソース | Package.ItemsとGetStatusメソッドの定義 |
| TaskDialog.vb | `Source/UI/TaskDialog.vb` | ソース | タスクダイアログUIコンポーネント |
