# 通知設計書 73-必須ツール全正常通知

## 概要

本ドキュメントは、StaxRipアプリケーションのAppsForm画面において、すべての必須ツールが正常状態であることを確認した際に表示される情報通知の設計仕様を定義する。

### 本通知の処理概要

本通知は、AppsForm画面でユーザーが「Check Required Only」機能を実行した結果、必須としてマークされているすべてのツールが正常なステータスであった場合に表示される。全ツールチェックとは異なり、オプショナルなツールは除外され、動画処理に必須のツールのみがチェック対象となる。

**業務上の目的・背景**：StaxRipでは多数のツールが登録されているが、すべてが必須ではない。基本的な動画エンコード作業には一部のコアツールのみが必要である。ユーザーが最小限の構成で作業を開始できるよう、必須ツールに限定したステータスチェック機能を提供し、その結果が正常であることを明確に通知する。これにより、初心者ユーザーでも混乱なく必要なセットアップを確認できる。

**通知の送信タイミング**：AppsForm画面の「Tools」メニューから「Check Required Only」（Ctrl+Y）を選択した際、必須ツールのステータスチェックが完了し、問題がない場合に表示される。

**通知の受信者**：AppsForm画面で「Check Required Only」機能を実行したユーザー。

**通知内容の概要**：「OK!」というタイトルと「All required tools have OK status!」という本文で、すべての必須ツールが正常であることを簡潔に伝える。

**期待されるアクション**：ユーザーは必須ツールがすべて正常であることを確認し、基本的な動画処理作業を開始できることを理解する。OKボタンをクリックしてダイアログを閉じる。

## 通知種別

アプリ内通知（タスクダイアログ）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期 |
| 優先度 | 中 |
| リトライ | 無 |

### 送信先決定ロジック

AppsForm画面で「Check Required Only」を実行し、Package.Items内でRequiredフラグがTrueのパッケージすべてのGetStatusが空文字列を返した場合（問題なし）に表示される。一つでも問題のある必須ツールがある場合は、代わりにそれらのツールの一覧が表示される。

## 通知テンプレート

### タスクダイアログ通知

| 項目 | 内容 |
|-----|------|
| アイコン | 情報（Info） |
| タイトル | OK! |
| ボタン | OK |

### 本文テンプレート

```
All required tools have OK status!
```

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| N/A | - | - | 添付ファイルなし |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| N/A | 固定メッセージのため変数なし | - | - |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 画面操作 | miStatusRequired.Clickイベント（Check Required Only） | すべての必須ツールのGetStatus = "" | Ctrl+Yショートカットでも実行可能 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| 1つ以上の必須ツールに問題がある | GetStatusが空でない必須ツールが存在する場合、問題リストが表示される |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[ユーザーがCheck Required Onlyを選択] --> B[Package.Itemsをループ]
    B --> C{pack.Required = True?}
    C -->|No| D[スキップ]
    C -->|Yes| E{pack.GetStatus = ""?}
    E -->|No| F[txtに問題追加、counter++]
    E -->|Yes| G[次のパッケージへ]
    D --> G
    F --> G
    G --> H{全パッケージ処理完了?}
    H -->|No| B
    H -->|Yes| I{txt = ""?}
    I -->|Yes| J[MsgInfo OK! All required tools have OK status!]
    I -->|No| K[MsgInfo counter apps found! txt]
    J --> L[終了]
    K --> L
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| N/A | データベース不使用 | メモリ上のPackage.Itemsを参照 |

### テーブル別参照項目詳細

Package.Items（Dictionary）内の各Packageオブジェクトに対して、Requiredプロパティを確認し、TrueのもののみGetStatusメソッドを評価する。

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| N/A | - | 更新処理なし |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| N/A | 同期ダイアログのため通常エラーなし | - |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし（ユーザー操作に応じて即座に表示）

## セキュリティ考慮事項

- 個人情報の取り扱い：なし
- 暗号化：不要
- 認証：不要

## 備考

- この通知は「All tools have OK status!」（全ツールチェック）とは異なり、Requiredフラグで絞り込む
- 必須ツールの定義はPackageオブジェクトのRequiredプロパティで管理される
- 必須ツールが見つからない場合、動画処理の主要機能が制限される可能性がある

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

パッケージ管理の構造とRequiredフラグを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Package.vb | `Source/General/Package.vb` | Package.Requiredプロパティの定義 |

**読解のコツ**: PackageクラスのRequiredプロパティがどのように設定されるかを確認する。

#### Step 2: エントリーポイントを理解する

処理の起点となるファイル・関数を特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | AppsForm.vb | `Source/Forms/AppsForm.vb` | miStatusRequired_Clickイベントハンドラ |

**主要処理フロー**:
1. **行920**: miStatusRequired_Clickサブルーチン開始
2. **行921-922**: counter変数とtxt変数の初期化
3. **行924-931**: Package.Itemsをループし、Requiredかつステータス異常のものを収集
4. **行927**: pack.Required条件でフィルタリング
5. **行933-937**: txtが空なら「All required tools have OK status!」を表示

#### Step 3: 通知表示処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | General.vb | `Source/General/General.vb` | MsgInfoメソッドの実装（行1216） |

**主要処理フロー**:
- **行1216-1220**: MsgInfoメソッドがTaskIcon.Infoでタスクダイアログを表示

### プログラム呼び出し階層図

```
AppsForm.miStatusRequired_Click
    │
    ├─ For Each pair In Package.Items
    │      │
    │      ├─ pack.Required チェック
    │      │
    │      └─ pack.GetStatus()
    │             │
    │             └─ ステータス文字列を返却
    │
    └─ MsgInfo("OK!", "All required tools have OK status!")
           │
           └─ Msg(title, content, TaskIcon.Info, TaskButton.OK)
                  │
                  └─ TaskDialog.Show()
```

### データフロー図

```
[入力]               [処理]                    [出力]

Package.Items ───▶ miStatusRequired_Click() ───▶ タスクダイアログ表示
                       │
                       ├─ Required フィルタ
                       │
                       ├─ GetStatus() × N
                       │
                       └─ txt = "" 判定
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| AppsForm.vb | `Source/Forms/AppsForm.vb` | ソース | miStatusRequired_Clickイベントハンドラ（行920-938） |
| General.vb | `Source/General/General.vb` | ソース | MsgInfo関数の定義（行1216） |
| Package.vb | `Source/General/Package.vb` | ソース | Package.RequiredプロパティとGetStatusメソッドの定義 |
| TaskDialog.vb | `Source/UI/TaskDialog.vb` | ソース | タスクダイアログUIコンポーネント |
