# 通知設計書 74-カスタムパス禁止エラー

## 概要

本ドキュメントは、StaxRipアプリケーションのAppsForm画面において、起動フォルダ内にカスタムパスを設定しようとした際に表示されるエラー通知の設計仕様を定義する。

### 本通知の処理概要

本通知は、ユーザーがツールのカスタムパスを設定する際に、StaxRipの起動フォルダ（スタートアップフォルダ）内のパスを選択した場合に表示される。起動フォルダ内へのカスタムパス設定はアプリケーションの更新プロセスを妨げる可能性があるため、セキュリティとメンテナンス性の観点から禁止されている。

**業務上の目的・背景**：StaxRipは定期的にアップデートされ、ユーザーは新しいバージョンを既存のインストールフォルダに上書きすることが多い。起動フォルダ内にカスタムパスを設定すると、アップデート時にツールが上書きされたり、カスタム設定が失われたりする可能性がある。このエラー通知により、ユーザーが意図せずメンテナンス困難な構成を作成することを防止する。

**通知の送信タイミング**：AppsForm画面で「Edit Path」（Ctrl+P）または「Find Path」（Ctrl+F）機能でパスを選択した際、選択されたパスが起動フォルダ内（設定フォルダを除く）であった場合に即座に表示される。

**通知の受信者**：AppsForm画面でカスタムパスを設定しようとしたユーザー。

**通知内容の概要**：「Custom paths within the startup folder are not permitted」というメッセージで、起動フォルダ内へのカスタムパス設定が許可されていないことを明確に伝え、ファイルを起動フォルダ外に配置するよう促す。

**期待されるアクション**：ユーザーはエラーメッセージを理解し、ツールファイルをStaxRipの起動フォルダ外の別の場所に配置し、再度カスタムパスを設定する。

## 通知種別

アプリ内通知（タスクダイアログ - エラー）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期 |
| 優先度 | 高 |
| リトライ | 無 |

### 送信先決定ロジック

以下の条件がすべて満たされた場合にエラーが表示される：
1. `s.AllowCustomPathsInStartupFolder`がFalse
2. 選択されたパスが`Folder.Startup`で始まる
3. 選択されたパスが`Folder.Settings`で始まらない（設定フォルダは例外）

## 通知テンプレート

### タスクダイアログ通知

| 項目 | 内容 |
|-----|------|
| アイコン | エラー（Error） |
| タイトル | Custom paths within the startup folder are not permitted |
| ボタン | OK |

### 本文テンプレート（Edit Path経由）

```
Custom paths within the startup folder are not permitted because it would prevent a simple update process.

Please put the file somewhere else outside the startup folder.
```

### 本文テンプレート（Find Path経由）

```
Custom paths within the startup folder are not permitted.
```

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| N/A | - | - | 添付ファイルなし |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| N/A | 固定メッセージのため変数なし | - | - |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 画面操作 | Edit Path（Ctrl+P） | パスがスタートアップフォルダ内（設定フォルダ除く） | OpenFileDialogでパス選択後 |
| 画面操作 | Find Path（Ctrl+F） | パスがスタートアップフォルダ内（設定フォルダ除く） | Everything検索結果からパス選択後 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| s.AllowCustomPathsInStartupFolder = True | 設定で起動フォルダ内パスが許可されている場合 |
| パスがFolder.Settings内 | 設定フォルダ内は例外的に許可 |

## 処理フロー

### 送信フロー（Edit Path）

```mermaid
flowchart TD
    A[ユーザーがEdit Pathを選択] --> B[OpenFileDialog表示]
    B --> C{ファイル選択?}
    C -->|No| D[キャンセル]
    C -->|Yes| E{s.AllowCustomPathsInStartupFolder?}
    E -->|Yes| F[パス設定実行]
    E -->|No| G{パスがStartup内?}
    G -->|No| F
    G -->|Yes| H{パスがSettings内?}
    H -->|Yes| F
    H -->|No| I[MsgError Custom paths within... 詳細メッセージ]
    I --> J[処理中断]
    F --> K[ShowActivePackage]
    D --> L[終了]
    J --> L
    K --> L
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| N/A | データベース不使用 | アプリケーション設定とフォルダパスを参照 |

### テーブル別参照項目詳細

以下の設定・定数を参照：
- `s.AllowCustomPathsInStartupFolder`: カスタムパス許可設定
- `Folder.Startup`: アプリケーション起動フォルダ
- `Folder.Settings`: 設定フォルダ

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| N/A | - | エラー時は更新処理なし |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| カスタムパス禁止 | 起動フォルダ内パス選択 | エラーメッセージ表示、処理中断 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし（ユーザー操作に応じて即座に表示）

## セキュリティ考慮事項

- 個人情報の取り扱い：なし
- 暗号化：不要
- 認証：不要
- セキュリティ目的：アプリケーション更新プロセスの保護

## 備考

- このエラーは`s.AllowCustomPathsInStartupFolder`設定でバイパス可能（上級者向け）
- 設定フォルダ（`Folder.Settings`）は例外として許可されている
- Edit PathとFind Pathで若干異なるメッセージ本文が表示される

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

フォルダパス管理の構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Folder.vb | `Source/General/Folder.vb` | Folder.StartupとFolder.Settingsの定義 |
| 1-2 | Settings.vb | `Source/General/Settings.vb` | AllowCustomPathsInStartupFolder設定の定義 |

**読解のコツ**: フォルダパスの取得方法と設定の永続化方法を確認する。

#### Step 2: エントリーポイントを理解する（Edit Path）

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | AppsForm.vb | `Source/Forms/AppsForm.vb` | miBrowsePath_Clickイベントハンドラ |

**主要処理フロー**:
1. **行940**: miBrowsePath_Clickサブルーチン開始
2. **行941-948**: OpenFileDialog設定
3. **行950**: ファイル選択確認
4. **行951-953**: 起動フォルダ内パスの条件チェック
5. **行955-957**: MsgErrorでエラー表示（詳細メッセージ付き）

#### Step 3: エントリーポイントを理解する（Find Path）

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | AppsForm.vb | `Source/Forms/AppsForm.vb` | Everythingメソッド（miFindPath_Click経由） |

**主要処理フロー**:
1. **行988-989**: miFindPath_Click → Everything()呼び出し
2. **行1043**: パス選択確認
3. **行1044-1046**: 起動フォルダ内パスの条件チェック
4. **行1048**: MsgErrorでエラー表示（簡潔なメッセージ）

#### Step 4: 通知表示処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | General.vb | `Source/General/General.vb` | MsgErrorメソッドの実装（行1222） |

**主要処理フロー**:
- **行1222-1241**: MsgErrorメソッドがTaskIcon.Errorでタスクダイアログを表示

### プログラム呼び出し階層図

```
AppsForm.miBrowsePath_Click / miFindPath_Click
    │
    ├─ OpenFileDialog / Everything検索
    │
    ├─ パス選択
    │      │
    │      ├─ s.AllowCustomPathsInStartupFolder チェック
    │      │
    │      ├─ Folder.Startup チェック
    │      │
    │      └─ Folder.Settings 例外チェック
    │
    └─ MsgError("Custom paths within the startup folder...")
           │
           └─ Msg(title, content, TaskIcon.Error, TaskButton.OK)
                  │
                  └─ TaskDialog.Show()
```

### データフロー図

```
[入力]               [処理]                    [出力]

選択パス ───────▶ miBrowsePath_Click() ───▶ エラーダイアログ
Folder.Startup ───▶        or               / パス設定成功
Folder.Settings ─▶ Everything()
s.AllowCustomPaths
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| AppsForm.vb | `Source/Forms/AppsForm.vb` | ソース | miBrowsePath_Click（行940-965）、Everything（行992-1061） |
| General.vb | `Source/General/General.vb` | ソース | MsgError関数の定義（行1222） |
| Folder.vb | `Source/General/Folder.vb` | ソース | Folder.StartupとFolder.Settingsの定義 |
| Settings.vb | `Source/General/Settings.vb` | ソース | AllowCustomPathsInStartupFolder設定 |
| TaskDialog.vb | `Source/UI/TaskDialog.vb` | ソース | タスクダイアログUIコンポーネント |
