# 通知設計書 75-カスタムパス未定義通知

## 概要

本ドキュメントは、StaxRipアプリケーションのAppsForm画面において、カスタムパスをクリアしようとした際に、定義されているカスタムパスが存在しない場合に表示される情報通知の設計仕様を定義する。

### 本通知の処理概要

本通知は、ユーザーが「Clear Paths」機能を使用してカスタムパスをクリアしようとした際に、クリア対象となるカスタムパスが一つも定義されていない場合に表示される。これにより、ユーザーは現在カスタムパスが設定されていないことを明確に理解できる。

**業務上の目的・背景**：StaxRipでは各ツールに対してカスタムパスを設定することで、デフォルトの場所以外にあるツールを使用できる。「Clear Paths」機能は設定されたカスタムパスを削除するために使用されるが、カスタムパスが一つも設定されていない場合、ユーザーに現在の状態を明確に通知する必要がある。これにより、不要な操作を防ぎ、ユーザーの混乱を避ける。

**通知の送信タイミング**：AppsForm画面の「Tools」メニューから「Clear Paths」（Ctrl+X）を選択した際、Package.Items内にGetStoredPathが空でないパッケージが一つも存在しない場合に表示される。

**通知の受信者**：AppsForm画面で「Clear Paths」機能を実行したユーザー。

**通知内容の概要**：「No custom paths defined.」という簡潔なメッセージで、カスタムパスが定義されていないことを伝える。

**期待されるアクション**：ユーザーは現在カスタムパスが設定されていないことを理解し、必要に応じて「Edit Path」や「Find Path」機能でカスタムパスを設定するか、そのまま操作を終了する。

## 通知種別

アプリ内通知（タスクダイアログ）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期 |
| 優先度 | 低 |
| リトライ | 無 |

### 送信先決定ロジック

Package.Items.Valuesに対してGetStoredPath()が空文字列でないものをフィルタリングし、結果が0件の場合に表示される。

## 通知テンプレート

### タスクダイアログ通知

| 項目 | 内容 |
|-----|------|
| アイコン | 情報（Info） |
| タイトル | No custom paths defined. |
| ボタン | OK |

### 本文テンプレート

```
No custom paths defined.
```

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| N/A | - | - | 添付ファイルなし |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| N/A | 固定メッセージのため変数なし | - | - |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 画面操作 | miClearPaths.Clickイベント（Clear Paths） | カスタムパスが定義されているパッケージが0件 | Ctrl+Xショートカットでも実行可能 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| カスタムパスが1件以上存在 | TaskDialogでクリア対象の選択画面が表示される |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[ユーザーがClear Pathsを選択] --> B[Package.Items.Valuesをフィルタ]
    B --> C{GetStoredPath != ""のパッケージ}
    C --> D{Count > 0?}
    D -->|Yes| E[TaskDialogで選択画面表示]
    D -->|No| F[MsgInfo No custom paths defined.]
    E --> G[ユーザーが選択]
    G --> H[SetStoredPath Nothing で削除]
    H --> I[ShowActivePackage]
    F --> J[終了]
    I --> J
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| N/A | データベース不使用 | メモリ上のPackage.Itemsを参照 |

### テーブル別参照項目詳細

Package.Items.Values内の各Packageオブジェクトに対してGetStoredPathメソッドを呼び出し、カスタムパスが設定されているかを確認する。

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| N/A | - | この通知表示時は更新処理なし |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| N/A | 同期ダイアログのため通常エラーなし | - |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし（ユーザー操作に応じて即座に表示）

## セキュリティ考慮事項

- 個人情報の取り扱い：なし
- 暗号化：不要
- 認証：不要

## 備考

- この通知はカスタムパスが存在しない状態を示す情報メッセージ
- カスタムパスが存在する場合は、代わりにTaskDialogでクリア対象の選択画面が表示される
- GetStoredPathはPackageオブジェクトのカスタムパス取得メソッド

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

パッケージのカスタムパス管理を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Package.vb | `Source/General/Package.vb` | GetStoredPathメソッドとSetStoredPathメソッドの定義 |

**読解のコツ**: カスタムパスがどのように保存・取得されるかを確認する。

#### Step 2: エントリーポイントを理解する

処理の起点となるファイル・関数を特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | AppsForm.vb | `Source/Forms/AppsForm.vb` | miClearCustomPath_Clickイベントハンドラ |

**主要処理フロー**:
1. **行967**: miClearCustomPath_Clickサブルーチン開始
2. **行968**: Package.Items.ValuesをGetStoredPath() != ""でフィルタ
3. **行970**: フィルタ結果のCountをチェック
4. **行971-982**: Count > 0の場合、TaskDialogで選択画面表示
5. **行983-985**: Count = 0の場合、MsgInfo("No custom paths defined.")

#### Step 3: 通知表示処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | General.vb | `Source/General/General.vb` | MsgInfoメソッドの実装（行1216） |

**主要処理フロー**:
- **行1216-1220**: MsgInfoメソッドがTaskIcon.Infoでタスクダイアログを表示

### プログラム呼び出し階層図

```
AppsForm.miClearCustomPath_Click
    │
    ├─ Package.Items.Values.Where(GetStoredPath() <> "")
    │      │
    │      └─ packs コレクション
    │
    ├─ packs.Count > 0 ?
    │      │
    │      ├─ Yes: TaskDialog表示 → 選択 → SetStoredPath(Nothing)
    │      │
    │      └─ No: MsgInfo("No custom paths defined.")
    │
    └─ ShowActivePackage()
```

### データフロー図

```
[入力]               [処理]                    [出力]

Package.Items ───▶ miClearCustomPath_Click() ───▶ 情報ダイアログ表示
                       │                         または
                       ├─ GetStoredPath() フィルタ  選択ダイアログ表示
                       │
                       └─ Count = 0 判定
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| AppsForm.vb | `Source/Forms/AppsForm.vb` | ソース | miClearCustomPath_Clickイベントハンドラ（行967-986） |
| General.vb | `Source/General/General.vb` | ソース | MsgInfo関数の定義（行1216） |
| Package.vb | `Source/General/Package.vb` | ソース | GetStoredPathとSetStoredPathメソッドの定義 |
| TaskDialog.vb | `Source/UI/TaskDialog.vb` | ソース | タスクダイアログUIコンポーネント |
