# 通知設計書 76-ファイル未検出エラー

## 概要

本ドキュメントは、StaxRipアプリケーションのAppsForm画面において、Everything検索で選択したパスのファイルが存在しない場合に表示されるエラー通知の設計仕様を定義する。

### 本通知の処理概要

本通知は、「Find Path」機能でvoidtools Everything検索を使用してファイルパスを選択した際、そのファイルが実際には存在しない場合に表示される。Everythingのインデックスが最新でない場合や、選択後にファイルが削除された場合などに発生する。

**業務上の目的・背景**：voidtools Everythingは高速なファイル検索ツールだが、インデックスベースで動作するため、インデックスが最新でない場合は既に存在しないファイルが検索結果に表示されることがある。ユーザーがそのようなファイルを選択した場合、明確なエラーメッセージでファイルが見つからないことを通知し、ユーザーがEverythingのインデックスを更新するか、別のファイルを選択するよう促す必要がある。

**通知の送信タイミング**：AppsForm画面の「Find Path」（Ctrl+F）機能でEverything検索結果からパスを選択した際、`td.SelectedValue.FileExists`がFalseかつ`td.SelectedValue`が空でない場合に表示される。

**通知の受信者**：AppsForm画面で「Find Path」機能を実行し、存在しないファイルを選択したユーザー。

**通知内容の概要**：「File not found」というタイトルと、選択されたパスを本文として表示し、どのファイルが見つからなかったかを明確に示す。

**期待されるアクション**：ユーザーはファイルが存在しないことを確認し、Everythingのインデックスを更新するか、正しいファイルパスを手動で設定するか、別のファイルを検索して選択する。

## 通知種別

アプリ内通知（タスクダイアログ - エラー）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期 |
| 優先度 | 中 |
| リトライ | 無 |

### 送信先決定ロジック

Everything検索結果のTaskDialogで選択されたパス（`td.SelectedValue`）に対して、`FileExists`が`False`かつ`td.SelectedValue`が空文字列でない場合にエラーが表示される。

## 通知テンプレート

### タスクダイアログ通知

| 項目 | 内容 |
|-----|------|
| アイコン | エラー（Error） |
| タイトル | File not found |
| ボタン | OK |

### 本文テンプレート

```
{選択されたファイルパス}
```

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| N/A | - | - | 添付ファイルなし |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| td.SelectedValue | 選択されたファイルパス | TaskDialog選択値 | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 画面操作 | Find Path（Ctrl+F） | td.SelectedValue.FileExists = False かつ td.SelectedValue <> "" | Everything検索結果からの選択後 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| td.SelectedValue.FileExists = True | ファイルが存在する場合 |
| td.SelectedValue = "" | 選択がキャンセルされた場合 |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[ユーザーがFind Pathを選択] --> B[Everything検索実行]
    B --> C{検索結果あり?}
    C -->|No| D[MsgInfo Nothing found.]
    C -->|Yes| E[TaskDialogで結果表示]
    E --> F[ユーザーがパス選択]
    F --> G{td.Show.FileExists?}
    G -->|Yes| H{起動フォルダ内チェック}
    G -->|No| I{td.SelectedValue <> ""?}
    I -->|No| J[キャンセル終了]
    I -->|Yes| K[MsgError File not found, td.SelectedValue]
    H --> L[パス設定または禁止エラー]
    K --> M[終了]
    J --> M
    L --> M
    D --> M
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| N/A | データベース不使用 | ファイルシステムを直接参照 |

### テーブル別参照項目詳細

ファイルシステムに対して`FileExists`拡張メソッドでファイル存在確認を行う。

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| N/A | - | エラー時は更新処理なし |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| ファイル未検出 | 選択パスにファイルが存在しない | エラーメッセージ表示、処理中断 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし（ユーザー操作に応じて即座に表示）

## セキュリティ考慮事項

- 個人情報の取り扱い：ファイルパスのみ表示
- 暗号化：不要
- 認証：不要

## 備考

- このエラーはEverythingのインデックスが古い場合に発生しやすい
- ファイルが存在する場合は、カスタムパス禁止チェック（起動フォルダ内かどうか）に進む
- voidtools Everythingがインストールされていない場合は、別の導入案内ダイアログが表示される

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

Everything検索との連携を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | AppsForm.vb | `Source/Forms/AppsForm.vb` | Everything DLLインポート（行1063-1092） |

**読解のコツ**: DllImportでEverything.dllの関数をインポートしている部分を確認する。

#### Step 2: エントリーポイントを理解する

処理の起点となるファイル・関数を特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | AppsForm.vb | `Source/Forms/AppsForm.vb` | Everythingメソッド（行992-1061） |

**主要処理フロー**:
1. **行988-989**: miFindPath_Click → Everything()呼び出し
2. **行992-1027**: Everything検索の非同期実行
3. **行1035-1057**: 検索結果の処理
4. **行1043**: td.Show.FileExistsでファイル存在確認
5. **行1054-1055**: ファイルが存在しない場合、MsgError("File not found", td.SelectedValue)

#### Step 3: 通知表示処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | General.vb | `Source/General/General.vb` | MsgErrorメソッドの実装（行1222） |

**主要処理フロー**:
- **行1222-1241**: MsgErrorメソッドがTaskIcon.Errorでタスクダイアログを表示

### プログラム呼び出し階層図

```
AppsForm.miFindPath_Click
    │
    └─ Everything()
           │
           ├─ Task.Run(Everything検索)
           │      │
           │      ├─ Everything_SetSearch()
           │      │
           │      ├─ Everything_Query()
           │      │
           │      └─ Everything_GetResultFullPathName()
           │
           ├─ paths.Count > 0 ?
           │      │
           │      ├─ Yes: TaskDialog表示
           │      │      │
           │      │      └─ td.Show.FileExists ?
           │      │             │
           │      │             ├─ Yes: 起動フォルダチェック → パス設定
           │      │             │
           │      │             └─ No: MsgError("File not found", path)
           │      │
           │      └─ No: MsgInfo("Nothing found.")
           │
           └─ 終了
```

### データフロー図

```
[入力]               [処理]                    [出力]

Everything検索 ───▶ Everything() ───▶ エラーダイアログ表示
     │                  │               「File not found」
     │                  │
     └─ パス選択 ───▶ FileExists チェック
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| AppsForm.vb | `Source/Forms/AppsForm.vb` | ソース | Everythingメソッド（行992-1061）、DLLインポート（行1063-1092） |
| General.vb | `Source/General/General.vb` | ソース | MsgError関数の定義（行1222） |
| TaskDialog.vb | `Source/UI/TaskDialog.vb` | ソース | タスクダイアログUIコンポーネント |
