# 通知設計書 77-検索結果なし通知

## 概要

本ドキュメントは、StaxRipアプリケーションのAppsForm画面において、Everything検索で結果が見つからなかった場合に表示される情報通知の設計仕様を定義する。

### 本通知の処理概要

本通知は、「Find Path」機能でvoidtools Everything検索を実行した結果、検索対象のファイル名に一致するファイルが一件も見つからなかった場合に表示される。これにより、ユーザーは検索が正常に実行されたが該当ファイルが存在しないことを理解できる。

**業務上の目的・背景**：StaxRipは多数の外部ツールに依存しており、ユーザーはそれらのツールをシステム内の任意の場所に配置することがある。「Find Path」機能はvoidtools Everythingを使用してファイルを高速に検索するが、検索結果がない場合にユーザーに明確なフィードバックを提供する必要がある。これにより、ユーザーはツールがインストールされていないか、Everythingのインデックスに含まれていないことを認識し、手動でパスを設定するか、ツールをインストールするかの判断ができる。

**通知の送信タイミング**：AppsForm画面の「Find Path」（Ctrl+F）機能でEverything検索を実行した後、検索結果（paths）のカウントが0の場合に表示される。

**通知の受信者**：AppsForm画面で「Find Path」機能を実行し、検索結果が得られなかったユーザー。

**通知内容の概要**：「Nothing found.」という簡潔なメッセージで、検索結果がないことを伝える。

**期待されるアクション**：ユーザーは検索結果がないことを確認し、ツールをインストールするか、Everythingのインデックスを更新するか、「Edit Path」機能で手動でパスを設定する。

## 通知種別

アプリ内通知（タスクダイアログ）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期 |
| 優先度 | 低 |
| リトライ | 無 |

### 送信先決定ロジック

Everything検索の実行後、検索結果リスト（paths）のカウントが0の場合に表示される。検索結果が1件以上ある場合は、TaskDialogで結果の選択画面が表示される。

## 通知テンプレート

### タスクダイアログ通知

| 項目 | 内容 |
|-----|------|
| アイコン | 情報（Info） |
| タイトル | Nothing found. |
| ボタン | OK |

### 本文テンプレート

```
Nothing found.
```

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| N/A | - | - | 添付ファイルなし |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| N/A | 固定メッセージのため変数なし | - | - |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 画面操作 | Find Path（Ctrl+F） | paths.Count = 0 | Everything検索結果が0件 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| paths.Count > 0 | 検索結果が1件以上ある場合 |
| Everything未インストール | Everythingエラーの場合は別のダイアログが表示される |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[ユーザーがFind Pathを選択] --> B[Everything検索実行]
    B --> C{Everythingエラー?}
    C -->|Yes| D[Everythingインストール案内]
    C -->|No| E[検索結果取得]
    E --> F{paths.Count > 0?}
    F -->|Yes| G[TaskDialogで結果表示]
    F -->|No| H[MsgInfo Nothing found.]
    G --> I[終了]
    H --> I
    D --> I
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| N/A | データベース不使用 | Everything検索を使用 |

### テーブル別参照項目詳細

voidtools Everythingの検索インデックスに対してクエリを実行する。

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| N/A | - | 更新処理なし |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| N/A | 同期ダイアログのため通常エラーなし | - |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし（ユーザー操作に応じて即座に表示）

## セキュリティ考慮事項

- 個人情報の取り扱い：なし
- 暗号化：不要
- 認証：不要

## 備考

- voidtools Everythingがインストールされていない場合は、代わりにインストール案内のダイアログが表示される
- 検索は`CurrentPackage.Filename`をキーとして実行される
- ファイル名の大文字小文字は区別されない（ToLowerInvariant比較）
- 検索結果は最大10件に制限される

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

Everything検索との連携を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | AppsForm.vb | `Source/Forms/AppsForm.vb` | pathsリストの定義と使用（行993） |

**読解のコツ**: paths変数がList(Of String)としてどのように検索結果を保持するかを確認する。

#### Step 2: エントリーポイントを理解する

処理の起点となるファイル・関数を特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | AppsForm.vb | `Source/Forms/AppsForm.vb` | Everythingメソッド（行992-1061） |

**主要処理フロー**:
1. **行988-989**: miFindPath_Click → Everything()呼び出し
2. **行993**: pathsリストの初期化
3. **行995-1027**: Everything検索の実行（非同期）
4. **行1000**: CurrentPackage.Filenameを検索キーに設定
5. **行1004-1015**: 検索結果をpathsに追加（最大10件）
6. **行1035**: paths.Count > 0 の判定
7. **行1058-1060**: paths.Count = 0 の場合、MsgInfo("Nothing found.")

#### Step 3: 通知表示処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | General.vb | `Source/General/General.vb` | MsgInfoメソッドの実装（行1216） |

**主要処理フロー**:
- **行1216-1220**: MsgInfoメソッドがTaskIcon.Infoでタスクダイアログを表示

### プログラム呼び出し階層図

```
AppsForm.miFindPath_Click
    │
    └─ Everything()
           │
           ├─ Task.Run(Everything検索)
           │      │
           │      ├─ Everything_SetSearch(CurrentPackage.Filename)
           │      │
           │      ├─ Everything_Query()
           │      │
           │      └─ Everything_GetResultFullPathName() × N
           │             │
           │             └─ paths.Add(path)
           │
           ├─ paths.Count > 0 ?
           │      │
           │      ├─ Yes: TaskDialog表示
           │      │
           │      └─ No: MsgInfo("Nothing found.")
           │
           └─ 終了
```

### データフロー図

```
[入力]               [処理]                    [出力]

CurrentPackage ───▶ Everything() ───▶ 情報ダイアログ表示
  .Filename           │               「Nothing found.」
                      │
                      ├─ Everything検索
                      │
                      └─ paths.Count = 0 判定
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| AppsForm.vb | `Source/Forms/AppsForm.vb` | ソース | Everythingメソッド（行992-1061）、miFindPath_Click（行988-990） |
| General.vb | `Source/General/General.vb` | ソース | MsgInfo関数の定義（行1216） |
| Package.vb | `Source/General/Package.vb` | ソース | CurrentPackage.Filenameの定義 |
| TaskDialog.vb | `Source/UI/TaskDialog.vb` | ソース | タスクダイアログUIコンポーネント |
