# 通知設計書 78-MediaFire非対応エラー

## 概要

本ドキュメントは、StaxRipアプリケーションのAppsForm画面において、MediaFireからの自動更新が非対応であることを示すエラー通知の設計仕様を定義する。

### 本通知の処理概要

本通知は、ユーザーがツールの自動更新機能（Auto Update）を実行しようとした際に、そのツールのダウンロードURLがMediaFireを指している場合に表示される。MediaFireはダウンロードリンクの構造上、自動化された直接ダウンロードが困難なため、自動更新機能の対象外となっている。

**業務上の目的・背景**：StaxRipのツール自動更新機能は、GitHubやその他の一般的なホスティングサービスからの直接ダウンロードをサポートしている。しかし、MediaFireはダウンロード前に中間ページを表示するため、自動化されたダウンロードが技術的に困難である。ユーザーが自動更新を試みた際に明確なエラーメッセージを表示し、手動でダウンロードする必要があることを伝える。

**通知の送信タイミング**：AppsForm画面の「Tools」メニューから「Auto Update」（Ctrl+U）を選択した際、`CurrentPackage.DownloadURL`に「mediafire」が含まれている場合に即座に表示される。

**通知の受信者**：AppsForm画面で「Auto Update」機能を実行し、対象ツールのダウンロードURLがMediaFireを使用しているユーザー。

**通知内容の概要**：「The auto update feature does currently not support MediaFire.」というメッセージで、MediaFireが自動更新に対応していないことを明確に伝える。

**期待されるアクション**：ユーザーはMediaFireが自動更新に対応していないことを理解し、「Download」ボタンまたはメニューからダウンロードページにアクセスして手動でツールを更新する。

## 通知種別

アプリ内通知（タスクダイアログ - エラー）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期 |
| 優先度 | 中 |
| リトライ | 無 |

### 送信先決定ロジック

`CurrentPackage.DownloadURL`が空でなく、かつURLに「mediafire」が含まれている場合にエラーが表示される。

## 通知テンプレート

### タスクダイアログ通知

| 項目 | 内容 |
|-----|------|
| アイコン | エラー（Error） |
| タイトル | The auto update feature does currently not support MediaFire. |
| ボタン | OK |

### 本文テンプレート

```
The auto update feature does currently not support MediaFire.
```

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| N/A | - | - | 添付ファイルなし |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| N/A | 固定メッセージのため変数なし | - | - |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 画面操作 | Auto Update（Ctrl+U） | DownloadURLに「mediafire」を含む | URLチェック後 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| DownloadURL = "" | ダウンロードURLが設定されていない場合（別の早期リターン） |
| URLに「mediafire」を含まない | MediaFire以外のURLの場合は自動更新処理が続行 |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[ユーザーがAuto Updateを選択] --> B{DownloadURL = ""?}
    B -->|Yes| C[Exit Sub 早期リターン]
    B -->|No| D{URLに mediafire を含む?}
    D -->|Yes| E[MsgError MediaFire非対応メッセージ]
    E --> F[Exit Sub]
    D -->|No| G{実験的機能の確認ダイアログ}
    G -->|OK| H[ToolUpdate開始]
    G -->|Cancel| I[キャンセル]
    C --> J[終了]
    F --> J
    H --> J
    I --> J
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| N/A | データベース不使用 | CurrentPackage.DownloadURLを参照 |

### テーブル別参照項目詳細

Package.DownloadURLプロパティの値を文字列検索する。

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| N/A | - | エラー時は更新処理なし |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| MediaFire非対応 | ダウンロードURLがMediaFireを使用 | エラーメッセージ表示、処理中断 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし（ユーザー操作に応じて即座に表示）

## セキュリティ考慮事項

- 個人情報の取り扱い：なし
- 暗号化：不要
- 認証：不要

## 備考

- MediaFireはダウンロード前に中間ページを表示するため、自動ダウンロードが困難
- 将来的にMediaFireサポートが追加される可能性は低い
- ユーザーは手動で「Download」機能を使用してツールを更新できる
- 自動更新機能自体が「実験的機能」として位置付けられている

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

パッケージのダウンロードURL管理を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Package.vb | `Source/General/Package.vb` | DownloadURLプロパティの定義 |

**読解のコツ**: DownloadURLがどのように設定されるかを確認する。

#### Step 2: エントリーポイントを理解する

処理の起点となるファイル・関数を特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | AppsForm.vb | `Source/Forms/AppsForm.vb` | miAutoUpdate_Clickイベントハンドラ |

**主要処理フロー**:
1. **行1098**: miAutoUpdate_Clickサブルーチン開始
2. **行1099**: url変数にCurrentPackage.DownloadURLを代入
3. **行1101-1102**: url = ""の場合、早期リターン
4. **行1105-1107**: urlに「mediafire」が含まれる場合、MsgErrorを表示してリターン
5. **行1110-1113**: 実験的機能確認ダイアログ表示後、ToolUpdate開始

#### Step 3: 通知表示処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | General.vb | `Source/General/General.vb` | MsgErrorメソッドの実装（行1222） |

**主要処理フロー**:
- **行1222-1241**: MsgErrorメソッドがTaskIcon.Errorでタスクダイアログを表示

### プログラム呼び出し階層図

```
AppsForm.miAutoUpdate_Click
    │
    ├─ url = CurrentPackage.DownloadURL
    │
    ├─ url = "" ?
    │      │
    │      └─ Yes: Exit Sub
    │
    ├─ url.Contains("mediafire") ?
    │      │
    │      ├─ Yes: MsgError("The auto update feature...")
    │      │        │
    │      │        └─ Exit Sub
    │      │
    │      └─ No: MsgQuestion("Experimental feature...")
    │             │
    │             ├─ OK: ToolUpdate.Update()
    │             │
    │             └─ Cancel: 終了
    │
    └─ 終了
```

### データフロー図

```
[入力]               [処理]                    [出力]

CurrentPackage ───▶ miAutoUpdate_Click() ───▶ エラーダイアログ表示
  .DownloadURL        │                        または
                      │                        ToolUpdate開始
                      ├─ Contains("mediafire") チェック
                      │
                      └─ MsgQuestion("Experimental...")
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| AppsForm.vb | `Source/Forms/AppsForm.vb` | ソース | miAutoUpdate_Clickイベントハンドラ（行1098-1114） |
| General.vb | `Source/General/General.vb` | ソース | MsgError関数の定義（行1222） |
| Package.vb | `Source/General/Package.vb` | ソース | DownloadURLプロパティの定義 |
| ToolUpdate.vb | `Source/General/ToolUpdate.vb` | ソース | 自動更新処理の実装 |
| TaskDialog.vb | `Source/UI/TaskDialog.vb` | ソース | タスクダイアログUIコンポーネント |
