# 通知設計書 79-パスコピー通知

## 概要

本ドキュメントは、StaxRipアプリケーションのAppsForm画面において、ツールのパスがクリップボードにコピーされた際に表示される情報通知の設計仕様を定義する。

### 本通知の処理概要

本通知は、ユーザーが「Copy Path」機能を使用して現在選択されているツールのファイルパスをクリップボードにコピーした際に、コピーが成功したことを確認するために表示される。

**業務上の目的・背景**：ユーザーは外部ツールのパスをコマンドラインやスクリプトで使用したい場合がある。StaxRipが認識しているツールのフルパスを簡単に取得し、他のアプリケーションで使用できるようにするため、「Copy Path」機能が提供されている。この通知により、コピー操作が成功したことをユーザーに明確にフィードバックし、次のアクションに進めることを促す。

**通知の送信タイミング**：AppsForm画面の「Tools」メニューから「Copy Path」を選択した際、`Clipboard.SetText`でパスをクリップボードに設定した直後に表示される。

**通知の受信者**：AppsForm画面で「Copy Path」機能を実行したユーザー。

**通知内容の概要**：「The path was copied to the clipboard.」というメッセージで、パスがクリップボードにコピーされたことを確認する。

**期待されるアクション**：ユーザーはパスがコピーされたことを確認し、必要なアプリケーション（コマンドプロンプト、テキストエディタ、スクリプト等）に貼り付けて使用する。

## 通知種別

アプリ内通知（タスクダイアログ）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期 |
| 優先度 | 低 |
| リトライ | 無 |

### 送信先決定ロジック

「Copy Path」メニュー項目がクリックされた場合、無条件で表示される。事前条件として、`miCopyPath.Enabled`が`True`（`CurrentPackage.Path <> ""`）である必要がある。

## 通知テンプレート

### タスクダイアログ通知

| 項目 | 内容 |
|-----|------|
| アイコン | 情報（Info） |
| タイトル | The path was copied to the clipboard. |
| ボタン | OK |

### 本文テンプレート

```
The path was copied to the clipboard.
```

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| N/A | - | - | 添付ファイルなし |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| N/A | 固定メッセージのため変数なし | - | - |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 画面操作 | miCopyPath.Clickイベント（Copy Path） | 常に表示 | ショートカットキーなし |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| miCopyPath.Enabled = False | パスが空の場合、メニュー項目自体が無効化される |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[ユーザーがCopy Pathを選択] --> B[Clipboard.SetText CurrentPackage.Path]
    B --> C[MsgInfo The path was copied to the clipboard.]
    C --> D[終了]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| N/A | データベース不使用 | CurrentPackage.Pathを参照 |

### テーブル別参照項目詳細

Package.Pathプロパティの値を取得してクリップボードにコピーする。

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| N/A | - | データベース更新なし |

#### システムクリップボード

| 操作 | 項目 | 更新値 | 備考 |
|-----|------|-------|------|
| SET | Clipboard | CurrentPackage.Path | システムクリップボードへのテキスト設定 |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| N/A | 同期ダイアログのため通常エラーなし | - |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし（ユーザー操作に応じて即座に表示）

## セキュリティ考慮事項

- 個人情報の取り扱い：ファイルパスのみ（機密情報を含む可能性は低い）
- 暗号化：不要
- 認証：不要
- クリップボード：システムクリップボードを使用（他アプリからアクセス可能）

## 備考

- この機能にはショートカットキーが設定されていない
- パスが空の場合は、メニュー項目自体が無効化される（ShowActivePackageメソッド内で制御）
- クリップボードへのコピーはClipboard.SetTextを使用

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

パッケージのパス管理を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Package.vb | `Source/General/Package.vb` | Pathプロパティの定義 |

**読解のコツ**: Pathプロパティがどのように計算されるかを確認する。

#### Step 2: エントリーポイントを理解する

処理の起点となるファイル・関数を特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | AppsForm.vb | `Source/Forms/AppsForm.vb` | miCopyPath_Clickイベントハンドラ |

**主要処理フロー**:
1. **行1150**: miCopyPath_Clickサブルーチン開始
2. **行1151**: Clipboard.SetText(CurrentPackage.Path)でパスをコピー
3. **行1152**: MsgInfo("The path was copied to the clipboard.")で通知表示

#### Step 3: メニュー項目の有効/無効制御を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | AppsForm.vb | `Source/Forms/AppsForm.vb` | ShowActivePackageメソッド |

**主要処理フロー**:
- **行527**: miCopyPath.Enabled = path <> "" でメニュー項目の有効/無効を制御

#### Step 4: 通知表示処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | General.vb | `Source/General/General.vb` | MsgInfoメソッドの実装（行1216） |

**主要処理フロー**:
- **行1216-1220**: MsgInfoメソッドがTaskIcon.Infoでタスクダイアログを表示

### プログラム呼び出し階層図

```
AppsForm.miCopyPath_Click
    │
    ├─ Clipboard.SetText(CurrentPackage.Path)
    │
    └─ MsgInfo("The path was copied to the clipboard.")
           │
           └─ Msg(title, content, TaskIcon.Info, TaskButton.OK)
                  │
                  └─ TaskDialog.Show()
```

### データフロー図

```
[入力]               [処理]                    [出力]

CurrentPackage ───▶ miCopyPath_Click() ───▶ システムクリップボード
  .Path               │
                      │                    ───▶ 情報ダイアログ表示
                      └─ Clipboard.SetText()
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| AppsForm.vb | `Source/Forms/AppsForm.vb` | ソース | miCopyPath_Clickイベントハンドラ（行1150-1153）、ShowActivePackage（行527） |
| General.vb | `Source/General/General.vb` | ソース | MsgInfo関数の定義（行1216） |
| Package.vb | `Source/General/Package.vb` | ソース | Pathプロパティの定義 |
| TaskDialog.vb | `Source/UI/TaskDialog.vb` | ソース | タスクダイアログUIコンポーネント |
