# 通知設計書 80-PATH追加通知

## 概要

本ドキュメントは、StaxRipアプリケーションのAppsForm画面において、ツールのフォルダがPATH環境変数に追加された際に表示される情報通知の設計仕様を定義する。

### 本通知の処理概要

本通知は、ユーザーが「PATH Env Var」機能から「Add」オプションを選択し、現在選択されているツールのディレクトリをPATH環境変数に正常に追加した際に表示される。これにより、コマンドプロンプトやPowerShellからツールをフルパス指定なしで実行できるようになる。

**業務上の目的・背景**：動画エンコード作業では、コマンドラインからツールを直接呼び出すことがある。PATH環境変数にツールのディレクトリを追加することで、ユーザーはフルパスを指定せずにツールを実行できるようになり、コマンドライン操作の利便性が向上する。この通知により、PATH環境変数への追加が成功したことをユーザーに明確にフィードバックする。

**通知の送信タイミング**：AppsForm画面の「Tools」メニューから「PATH Env Var」を選択し、表示されたTaskDialogで「Add」を選択した際、ディレクトリがまだPATHに含まれていない場合に、追加処理完了後に表示される。

**通知の受信者**：AppsForm画面で「PATH Env Var」→「Add」を実行したユーザー。

**通知内容の概要**：「Folder was added to PATH」というメッセージで、フォルダがPATH環境変数に追加されたことを確認する。

**期待されるアクション**：ユーザーはPATH環境変数への追加が成功したことを確認し、新しいコマンドプロンプトやPowerShellウィンドウを開いて、追加されたツールをパス指定なしで使用できることを確認する。

## 通知種別

アプリ内通知（タスクダイアログ）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期 |
| 優先度 | 中 |
| リトライ | 無 |

### 送信先決定ロジック

以下の条件がすべて満たされた場合に表示される：
1. 「PATH Env Var」TaskDialogで「Add」が選択された
2. 現在のPATH環境変数にツールのディレクトリが含まれていない
3. `Environment.SetEnvironmentVariable`による追加が成功した

## 通知テンプレート

### タスクダイアログ通知

| 項目 | 内容 |
|-----|------|
| アイコン | 情報（Info） |
| タイトル | Folder was added to PATH |
| ボタン | OK |

### 本文テンプレート

```
Folder was added to PATH
```

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| N/A | - | - | 添付ファイルなし |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| N/A | 固定メッセージのため変数なし | - | - |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 画面操作 | miPATHEnvVar.Click → TaskDialog「Add」選択 | ディレクトリがPATHに未登録 | 追加成功後 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| ディレクトリがPATHに既存 | 「Folder is already in PATH」エラーが表示される |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[ユーザーがPATH Env Varを選択] --> B[TaskDialog表示 Add/Remove/Editor]
    B --> C{選択?}
    C -->|Add| D{pathItems.Contains dir?}
    D -->|Yes| E[MsgError Folder is already in PATH]
    D -->|No| F[pathItems.Add dir]
    F --> G[Environment.SetEnvironmentVariable]
    G --> H[MsgInfo Folder was added to PATH]
    C -->|Remove| I[Remove処理...]
    C -->|Editor| J[環境変数エディタ起動]
    E --> K[終了]
    H --> K
    I --> K
    J --> K
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| N/A | データベース不使用 | 環境変数を参照 |

### テーブル別参照項目詳細

- `Environment.GetEnvironmentVariable("path", pathTarget)`: 現在のPATH環境変数を取得
- `CurrentPackage.Directory`: ツールのディレクトリパスを取得

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| N/A | - | データベース更新なし |

#### 環境変数更新

| 操作 | 項目 | 更新値 | 備考 |
|-----|------|-------|------|
| SET | PATH環境変数 | 既存PATH + CurrentPackage.Directory | EnvironmentVariableTarget.UserまたはProcess |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| 既存登録エラー | ディレクトリがPATHに既存 | MsgError("Folder is already in PATH") |
| 例外発生 | SetEnvironmentVariable失敗 | g.ShowException(ex) |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし（ユーザー操作に応じて即座に表示）

## セキュリティ考慮事項

- 個人情報の取り扱い：なし
- 暗号化：不要
- 認証：不要
- 権限：WindowsではEnvironmentVariableTarget.Userを使用（管理者権限不要）
- Unix系ではEnvironmentVariableTarget.Processを使用（永続化されない）

## 備考

- WindowsではEnvironmentVariableTarget.Userを使用し、ユーザー環境変数を永続的に変更
- Unix系（Linux、macOS）ではEnvironmentVariableTarget.Processを使用し、現在のプロセスのみに影響
- 追加した変更は新しいコマンドプロンプト/ターミナルで有効になる
- 「Remove」オプションでPATHからの削除、「Editor」オプションで環境変数エディタの起動も可能

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

PATH環境変数の操作方法を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | AppsForm.vb | `Source/Forms/AppsForm.vb` | pathTarget変数の決定（行1159） |

**読解のコツ**: WindowsとUnix系でEnvironmentVariableTargetが異なることを確認する。

#### Step 2: エントリーポイントを理解する

処理の起点となるファイル・関数を特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | AppsForm.vb | `Source/Forms/AppsForm.vb` | miPATHEnvVar_Clickイベントハンドラ |

**主要処理フロー**:
1. **行1155**: miPATHEnvVar_Clickサブルーチン開始
2. **行1157-1162**: pathTargetとpathItemsの初期化
3. **行1164-1168**: TaskDialogでAdd/Remove/Editorの選択肢を表示
4. **行1170-1178**: 「Add」選択時の処理
5. **行1172-1173**: pathItems.Contains(dir)で既存チェック、既存なら「Folder is already in PATH」エラー
6. **行1175-1177**: pathItems.Add → SetEnvironmentVariable → MsgInfo("Folder was added to PATH")

#### Step 3: 通知表示処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | General.vb | `Source/General/General.vb` | MsgInfoメソッドの実装（行1216） |

**主要処理フロー**:
- **行1216-1220**: MsgInfoメソッドがTaskIcon.Infoでタスクダイアログを表示

### プログラム呼び出し階層図

```
AppsForm.miPATHEnvVar_Click
    │
    ├─ Environment.GetEnvironmentVariable("path", pathTarget)
    │
    ├─ pathVar.Split(...) → pathItems (List)
    │
    ├─ TaskDialog (Add/Remove/Editor)
    │      │
    │      ├─ "add"
    │      │      │
    │      │      ├─ pathItems.Contains(dir) ?
    │      │      │      │
    │      │      │      ├─ Yes: MsgError("Folder is already in PATH")
    │      │      │      │
    │      │      │      └─ No: pathItems.Add(dir)
    │      │      │              │
    │      │      │              ├─ Environment.SetEnvironmentVariable(...)
    │      │      │              │
    │      │      │              └─ MsgInfo("Folder was added to PATH")
    │      │
    │      ├─ "remove"
    │      │      └─ Remove処理...
    │      │
    │      └─ "edit"
    │             └─ rundll32.exe sysdm.cpl,EditEnvironmentVariables
    │
    └─ 終了
```

### データフロー図

```
[入力]                   [処理]                    [出力]

PATH環境変数 ─────────▶ miPATHEnvVar_Click() ───▶ PATH環境変数更新
CurrentPackage.Directory ▶         │
                                   │              ───▶ 情報ダイアログ表示
                                   ├─ pathItems.Contains() チェック
                                   │
                                   └─ Environment.SetEnvironmentVariable()
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| AppsForm.vb | `Source/Forms/AppsForm.vb` | ソース | miPATHEnvVar_Clickイベントハンドラ（行1155-1194） |
| General.vb | `Source/General/General.vb` | ソース | MsgInfo関数の定義（行1216）、MsgError関数の定義（行1222） |
| Package.vb | `Source/General/Package.vb` | ソース | Directoryプロパティの定義 |
| TaskDialog.vb | `Source/UI/TaskDialog.vb` | ソース | タスクダイアログUIコンポーネント |
