# 通知設計書 81-PATH削除通知

## 概要

本ドキュメントは、StaxRipアプリケーションにおけるPATH削除通知の設計仕様を定義します。この通知は、ユーザーがツール管理画面（AppsForm）からPATH環境変数のフォルダを削除した際に表示される情報通知です。

### 本通知の処理概要

**業務上の目的・背景**：StaxRipは複数の外部ツール（エンコーダ、デマクサ等）を使用するアプリケーションであり、これらのツールがシステムから直接実行できるようにPATH環境変数を管理する機能が必要です。PATH削除通知は、ユーザーがPATH環境変数からツールのフォルダを正常に削除できたことを確認するためのフィードバック機能です。これにより、ユーザーはシステム環境の変更が正しく反映されたことを即座に把握できます。

**通知の送信タイミング**：AppsForm画面でツールを選択し、コンテキストメニューまたはメニューバーから「PATH Environment Variable」を選択し、表示されるタスクダイアログで「Remove」を選択した際に、対象フォルダがPATH環境変数に存在し、かつ正常に削除処理が完了した直後に通知が発生します。

**通知の受信者**：アプリケーションを操作している現在のユーザー（GUI上でダイアログとして表示）。

**通知内容の概要**：「Folder was removed from PATH」という情報メッセージを表示し、PATH環境変数からフォルダが正常に削除されたことを通知します。

**期待されるアクション**：ユーザーは通知を確認し、OKボタンをクリックして作業を続行します。必要に応じて、環境変数エディタで変更結果を確認することもできます。

## 通知種別

アプリ内通知（TaskDialogによるモーダルダイアログ）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期 |
| 優先度 | 中 |
| リトライ | なし |

### 送信先決定ロジック

現在操作中のユーザーに対して、GUIのモーダルダイアログとして直接表示します。送信先の決定ロジックは不要で、常にアクティブなウィンドウの前面に表示されます。

## 通知テンプレート

### ダイアログ通知の場合

| 項目 | 内容 |
|-----|------|
| ダイアログ種別 | MsgInfo（情報通知） |
| アイコン | Information |
| タイトル | アプリケーション名（StaxRip） |
| ボタン | OK |

### 本文テンプレート

```
Folder was removed from PATH
```

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| なし | - | - | 本通知に添付ファイルはありません |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| なし | 本通知は固定メッセージのため変数を使用しません | - | - |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 画面操作 | PATH環境変数メニューで「Remove」選択 | 対象フォルダがPATHに存在する | ユーザーがAppsFormからPATH削除を実行した場合 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| フォルダがPATHに存在しない | フォルダがPATH環境変数に存在しない場合、削除通知の代わりにエラー通知（PATH未登録エラー）が表示される |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[ユーザーがPATHメニューからRemoveを選択] --> B[PATH環境変数を取得]
    B --> C{フォルダがPATHに存在するか}
    C -->|存在する| D[リストからフォルダを削除]
    D --> E[環境変数を更新]
    E --> F[MsgInfo表示: Folder was removed from PATH]
    F --> G[終了]
    C -->|存在しない| H[MsgError表示: Folder is not in PATH]
    H --> G
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| なし | 本機能はデータベースを使用しません | 環境変数を直接操作 |

### テーブル別参照項目詳細

本機能はデータベースを使用せず、OSの環境変数を直接操作します。

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| なし | - | 環境変数を直接更新 |

#### 環境変数更新詳細

| 操作 | 項目 | 更新値 | 備考 |
|-----|------|-------|------|
| UPDATE | PATH環境変数 | フォルダを除外したパスリスト | EnvironmentVariableTarget.User（Windows）またはProcess（非Windows） |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| PATH未登録エラー | 対象フォルダがPATHに存在しない | MsgError「Folder is not in PATH」を表示 |
| 例外発生 | 環境変数操作中に例外発生 | g.ShowException(ex)で例外詳細を表示 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | - |
| リトライ対象エラー | - |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | なし（ユーザー操作による同期通知） |
| 1日あたり上限 | なし |

### 配信時間帯

制限なし。ユーザー操作に応じて即座に表示されます。

## セキュリティ考慮事項

- PATH環境変数の変更はユーザースコープ（Windows）またはプロセススコープ（非Windows）で行われ、システム全体には影響しません
- 管理者権限は不要です
- 変更内容は即座に現在のプロセスに反映されます

## 備考

- Windows環境ではEnvironmentVariableTarget.Userを使用するため、変更は永続化されます
- 非Windows環境ではEnvironmentVariableTarget.Processを使用するため、変更は現在のプロセスにのみ適用されます
- 関連する通知として「PATH追加通知」（No.80）、「PATH重複エラー」（No.82）、「PATH未登録エラー」（No.83）があります

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

PATH環境変数の管理は、文字列のリスト操作として実装されています。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Package.vb | `Source/General/Package.vb` | Packageクラスの構造、特にDirectoryプロパティがPATH操作の対象となるフォルダを提供 |

**読解のコツ**: VB.NETの構文に注意。CurrentPackage.Directoryでツールのインストールディレクトリを取得します。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | AppsForm.vb | `Source/Forms/AppsForm.vb` | miPATHEnvVar_Clickメソッドが処理の起点 |

**主要処理フロー**:
1. **行1155-1159**: プラットフォーム判定とEnvironmentVariableTargetの決定
2. **行1160-1162**: 現在のPATH環境変数を取得してリスト化
3. **行1164-1168**: TaskDialogでユーザーに操作を選択させる

#### Step 3: PATH削除処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | AppsForm.vb | `Source/Forms/AppsForm.vb` | 行1179-1186のCase "remove"ブロック |

**主要処理フロー**:
- **行1180**: pathItems.Contains(dir)でフォルダの存在確認
- **行1181**: pathItems.Remove(dir)でリストからフォルダを削除
- **行1182**: Environment.SetEnvironmentVariableで環境変数を更新
- **行1183**: MsgInfo("Folder was removed from PATH")で通知表示

#### Step 4: 通知表示の仕組みを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | Msg.vb | `Source/UI/Msg.vb` | MsgInfo関数の実装、TaskDialogを使用した情報通知表示 |

### プログラム呼び出し階層図

```
AppsForm.miPATHEnvVar_Click (行1155)
    │
    ├─ Environment.GetEnvironmentVariable("path", pathTarget) (行1161)
    │
    ├─ TaskDialog.Show() (行1170)
    │      └─ Case "remove" (行1179)
    │              ├─ pathItems.Contains(dir) (行1180)
    │              ├─ pathItems.Remove(dir) (行1181)
    │              ├─ Environment.SetEnvironmentVariable (行1182)
    │              └─ MsgInfo("Folder was removed from PATH") (行1183)
    │
    └─ g.ShowException(ex) (行1192) [例外時]
```

### データフロー図

```
[入力]                      [処理]                           [出力]

CurrentPackage.Directory ──▶ pathItems.Contains() ──▶ 存在確認結果
                                   │
                                   ▼
PATH環境変数 ────────────▶ pathItems.Remove() ───▶ 更新後リスト
                                   │
                                   ▼
                          SetEnvironmentVariable() ──▶ 環境変数更新
                                   │
                                   ▼
                              MsgInfo() ───────────▶ 通知ダイアログ
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| AppsForm.vb | `Source/Forms/AppsForm.vb` | ソース | ツール管理画面、PATH操作の実装 |
| Msg.vb | `Source/UI/Msg.vb` | ソース | MsgInfo等の通知表示関数 |
| Package.vb | `Source/General/Package.vb` | ソース | パッケージ情報（ツールのパス等）の管理 |
| TaskDialog.vb | `Source/UI/TaskDialog.vb` | ソース | TaskDialogラッパークラス |
