# 通知設計書 83-PATH未登録エラー

## 概要

本ドキュメントは、StaxRipアプリケーションにおけるPATH未登録エラーの設計仕様を定義します。この通知は、ユーザーがツール管理画面（AppsForm）からPATH環境変数のフォルダを削除しようとした際に、そのフォルダがPATHに存在しない場合に表示されるエラー通知です。

### 本通知の処理概要

**業務上の目的・背景**：StaxRipでは外部ツールをシステムから直接実行できるようにPATH環境変数を管理する機能を提供しています。PATH未登録エラーは、ユーザーがPATHに登録されていないフォルダを削除しようとした際に、その操作が不可能であることを通知するエラーフィードバック機能です。これにより、ユーザーは削除対象のフォルダがPATHに存在しないことを明確に認識し、適切な対処を行うことができます。

**通知の送信タイミング**：AppsForm画面でツールを選択し、コンテキストメニューまたはメニューバーから「PATH Environment Variable」を選択し、表示されるタスクダイアログで「Remove」を選択した際に、対象フォルダがPATH環境変数に存在しない場合に通知が発生します。

**通知の受信者**：アプリケーションを操作している現在のユーザー（GUI上でダイアログとして表示）。

**通知内容の概要**：「Folder is not in PATH」というエラーメッセージを表示し、指定したフォルダがPATH環境変数に登録されていないことを通知します。

**期待されるアクション**：ユーザーは通知を確認し、OKボタンをクリックして作業を続行します。必要に応じて、環境変数エディタで現在のPATH設定を確認することができます。

## 通知種別

アプリ内通知（TaskDialogによるモーダルダイアログ - エラー通知）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期 |
| 優先度 | 中 |
| リトライ | なし |

### 送信先決定ロジック

現在操作中のユーザーに対して、GUIのモーダルダイアログとして直接表示します。送信先の決定ロジックは不要で、常にアクティブなウィンドウの前面に表示されます。

## 通知テンプレート

### ダイアログ通知の場合

| 項目 | 内容 |
|-----|------|
| ダイアログ種別 | MsgError（エラー通知） |
| アイコン | Error |
| タイトル | アプリケーション名（StaxRip） |
| ボタン | OK |

### 本文テンプレート

```
Folder is not in PATH
```

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| なし | - | - | 本通知に添付ファイルはありません |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| なし | 本通知は固定メッセージのため変数を使用しません | - | - |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 画面操作 | PATH環境変数メニューで「Remove」選択 | 対象フォルダがPATHに存在しない | ユーザーがAppsFormからPATH削除を実行し、未登録の場合 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| フォルダがPATHに存在する | フォルダがPATH環境変数に存在する場合、未登録エラーの代わりに正常に削除処理が実行され、PATH削除通知が表示される |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[ユーザーがPATHメニューからRemoveを選択] --> B[PATH環境変数を取得]
    B --> C{フォルダがPATHに存在するか}
    C -->|存在しない| D[MsgError表示: Folder is not in PATH]
    D --> E[終了]
    C -->|存在する| F[リストからフォルダを削除]
    F --> G[環境変数を更新]
    G --> H[MsgInfo表示: Folder was removed from PATH]
    H --> E
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| なし | 本機能はデータベースを使用しません | 環境変数を直接参照 |

### テーブル別参照項目詳細

本機能はデータベースを使用せず、OSの環境変数を直接参照します。

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| なし | - | エラー発生時は環境変数は更新されない |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| PATH未登録エラー | 対象フォルダがPATHに存在しない | MsgError「Folder is not in PATH」を表示 |
| 例外発生 | 環境変数操作中に例外発生 | g.ShowException(ex)で例外詳細を表示 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | - |
| リトライ対象エラー | - |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | なし（ユーザー操作による同期通知） |
| 1日あたり上限 | なし |

### 配信時間帯

制限なし。ユーザー操作に応じて即座に表示されます。

## セキュリティ考慮事項

- PATH環境変数の参照のみを行い、エラー発生時は環境変数を変更しません
- 管理者権限は不要です

## 備考

- 本エラーは、ユーザーの誤操作を防ぐためのバリデーション機能として実装されています
- ユーザーが削除しようとしたフォルダがPATHに追加されていない状態であることを示します
- 関連する通知として「PATH追加通知」（No.80）、「PATH削除通知」（No.81）、「PATH重複エラー」（No.82）があります

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

PATH環境変数の管理は、文字列のリスト操作として実装されています。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Package.vb | `Source/General/Package.vb` | Packageクラスの構造、特にDirectoryプロパティがPATH操作の対象となるフォルダを提供 |

**読解のコツ**: VB.NETの構文に注意。CurrentPackage.Directoryでツールのインストールディレクトリを取得します。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | AppsForm.vb | `Source/Forms/AppsForm.vb` | miPATHEnvVar_Clickメソッドが処理の起点 |

**主要処理フロー**:
1. **行1155-1159**: プラットフォーム判定とEnvironmentVariableTargetの決定
2. **行1160-1162**: 現在のPATH環境変数を取得してリスト化
3. **行1164-1168**: TaskDialogでユーザーに操作を選択させる

#### Step 3: PATH削除時の存在チェックを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | AppsForm.vb | `Source/Forms/AppsForm.vb` | 行1179-1186のCase "remove"ブロック |

**主要処理フロー**:
- **行1180**: pathItems.Contains(dir)でフォルダの存在確認
- **行1184-1185**: フォルダが存在しない場合（Else分岐）でMsgError("Folder is not in PATH")を表示
- **行1181-1183**: 存在する場合のみ削除処理を実行

#### Step 4: 通知表示の仕組みを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | Msg.vb | `Source/UI/Msg.vb` | MsgError関数の実装、TaskDialogを使用したエラー通知表示 |

### プログラム呼び出し階層図

```
AppsForm.miPATHEnvVar_Click (行1155)
    │
    ├─ Environment.GetEnvironmentVariable("path", pathTarget) (行1161)
    │
    ├─ TaskDialog.Show() (行1170)
    │      └─ Case "remove" (行1179)
    │              ├─ pathItems.Contains(dir) (行1180)
    │              └─ Else分岐: MsgError("Folder is not in PATH") (行1185) [未登録時]
    │
    └─ g.ShowException(ex) (行1192) [例外時]
```

### データフロー図

```
[入力]                      [処理]                           [出力]

CurrentPackage.Directory ──▶ pathItems.Contains() ──▶ 存在確認結果
                                   │
                                   ▼ [存在しない場合]
                              MsgError() ───────────▶ エラーダイアログ
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| AppsForm.vb | `Source/Forms/AppsForm.vb` | ソース | ツール管理画面、PATH操作の実装 |
| Msg.vb | `Source/UI/Msg.vb` | ソース | MsgError等の通知表示関数 |
| Package.vb | `Source/General/Package.vb` | ソース | パッケージ情報（ツールのパス等）の管理 |
| TaskDialog.vb | `Source/UI/TaskDialog.vb` | ソース | TaskDialogラッパークラス |
