# 通知設計書 84-デマクサ名不一致警告

## 概要

本ドキュメントは、StaxRipアプリケーションにおけるデマクサ名不一致警告の設計仕様を定義します。この通知は、コマンドラインデマクサ設定画面（CommandLineDemuxForm）でユーザーがヘルプを表示しようとした際に、設定されたデマクサ名がStaxRipに同梱されているアプリ名と一致しない場合に表示される警告通知です。

### 本通知の処理概要

**業務上の目的・背景**：StaxRipでは様々なコマンドラインツール（ffmpeg、mkvextract等）をデマクサとして使用できます。ユーザーがカスタムデマクサを設定する際、デマクサ名をStaxRipに同梱されているパッケージ名と一致させると、Helpメニューからそのツールのヘルプを参照できるようになります。デマクサ名不一致警告は、設定された名前がStaxRipの既知のアプリと一致しないことをユーザーに通知し、利用可能なアプリ名の一覧を提示することで、ヘルプ機能を活用するための正しい設定をガイドします。

**通知の送信タイミング**：CommandLineDemuxForm画面でHelpメニューを選択した際に、設定されたデマクサ名（tbName.Text）がPackage.Items.Values内のいずれのパッケージ名とも一致しない場合に通知が発生します。

**通知の受信者**：アプリケーションを操作している現在のユーザー（GUI上でダイアログとして表示）。

**通知内容の概要**：「The demuxer name '{name}' does not match with the name of one of StaxRip's apps.」というメッセージと、StaxRipに同梱されているアプリ名の一覧を表示します。

**期待されるアクション**：ユーザーは表示されたアプリ名一覧を参考に、必要に応じてデマクサ名を変更して、ヘルプ機能を活用できるようにするか、そのまま現在の設定を維持するかを判断します。

## 通知種別

アプリ内通知（TaskDialogによるモーダルダイアログ - 警告通知）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期 |
| 優先度 | 低 |
| リトライ | なし |

### 送信先決定ロジック

現在操作中のユーザーに対して、GUIのモーダルダイアログとして直接表示します。送信先の決定ロジックは不要で、常にアクティブなウィンドウの前面に表示されます。

## 通知テンプレート

### ダイアログ通知の場合

| 項目 | 内容 |
|-----|------|
| ダイアログ種別 | MsgWarn（警告通知） |
| アイコン | Warning |
| タイトル | アプリケーション名（StaxRip） |
| ボタン | OK |

### 本文テンプレート

```
The demuxer name '{name}' does not match with the name of one of StaxRip's apps. StaxRip includes the following apps:

{appList}
```

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| なし | - | - | 本通知に添付ファイルはありません |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| {name} | ユーザーが設定したデマクサ名 | tbName.Text | Yes |
| {appList} | StaxRipに同梱されているアプリ名の一覧（カンマ区切り） | Package.Items.Values（PluginPackageを除く） | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 画面操作 | CommandLineDemuxFormでHelpメニュー選択 | デマクサ名がパッケージ名と一致しない | ユーザーがヘルプを要求したが、該当パッケージが見つからない場合 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| デマクサ名がパッケージ名と一致する | 一致するパッケージが見つかった場合、警告の代わりにそのパッケージのヘルプが表示される |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[ユーザーがHelpメニューを選択] --> B[Package.Items.Valuesをループ]
    B --> C{tbName.Textとpack.Nameが一致するか}
    C -->|一致する| D[pack.ShowHelp]
    D --> E[終了]
    C -->|ループ終了まで一致しない| F[アプリ名一覧を生成]
    F --> G[MsgWarn表示: デマクサ名不一致メッセージ]
    G --> E
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| なし | 本機能はデータベースを使用しません | メモリ上のPackage.Items辞書を参照 |

### テーブル別参照項目詳細

本機能はデータベースを使用せず、Package.Items.Valuesコレクションからパッケージ情報を参照します。

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| なし | - | 本機能はデータを更新しません |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| 該当パッケージなし | デマクサ名がいずれのパッケージ名とも一致しない | MsgWarnで警告メッセージを表示し、利用可能なアプリ名一覧を提示 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | - |
| リトライ対象エラー | - |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | なし（ユーザー操作による同期通知） |
| 1日あたり上限 | なし |

### 配信時間帯

制限なし。ユーザー操作に応じて即座に表示されます。

## セキュリティ考慮事項

- 読み取り専用の操作であり、システムに変更を加えません
- ユーザーが入力したデマクサ名をメッセージに含めますが、サニタイズは必要ありません（GUIダイアログ表示のため）

## 備考

- この警告は情報提供を目的としており、デマクサの動作自体には影響しません
- デマクサ名をStaxRipのパッケージ名と一致させることで、ヘルプ機能が利用可能になります
- PluginPackageはアプリ一覧から除外されます（Where句でフィルタリング）
- アプリ名一覧はソートされてカンマ区切りで表示されます

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Package.vb | `Source/General/Package.vb` | Packageクラス、Package.Items辞書、PluginPackageクラスの関係を理解 |

**読解のコツ**: Package.ItemsはDictionary(Of String, Package)型で、各パッケージの名前とインスタンスを保持しています。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | CommandLineDemuxForm.vb | `Source/Forms/CommandLineDemuxForm.vb` | HelpToolStripMenuItem_Clickメソッドが処理の起点 |

**主要処理フロー**:
1. **行420**: HelpToolStripMenuItem_Clickメソッドの開始
2. **行421-427**: Package.Items.Valuesをループし、一致するパッケージを検索
3. **行429-430**: 一致しない場合に警告メッセージを生成・表示

#### Step 3: 警告メッセージの生成を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | CommandLineDemuxForm.vb | `Source/Forms/CommandLineDemuxForm.vb` | 行429-430のMsgWarn呼び出し |

**主要処理フロー**:
- **行429-430**: MsgWarn呼び出しでメッセージ生成
  - tbName.Textでユーザー入力のデマクサ名を取得
  - Package.Items.ValuesからPluginPackageを除外してフィルタリング
  - Selectでパッケージ名を抽出し、ソート、カンマ区切りで結合

### プログラム呼び出し階層図

```
CommandLineDemuxForm.HelpToolStripMenuItem_Click (行420)
    │
    ├─ For Each pack In Package.Items.Values (行421)
    │      └─ If tbName.Text = pack.Name (行422)
    │              └─ pack.ShowHelp() (行423) [一致時]
    │
    └─ MsgWarn() (行429) [ループ終了後]
           └─ Package.Items.Values
                  .Where(PluginPackage除外)
                  .Select(package.Name)
                  .Sort.Join(", ")
```

### データフロー図

```
[入力]                         [処理]                              [出力]

tbName.Text ─────────────────▶ pack.Name比較ループ ──▶ 一致: ShowHelp()
                                      │
                                      ▼ [不一致]
Package.Items.Values ────────▶ フィルタリング＆ソート ──▶ アプリ一覧文字列
                                      │
                                      ▼
                                 MsgWarn() ─────────▶ 警告ダイアログ
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| CommandLineDemuxForm.vb | `Source/Forms/CommandLineDemuxForm.vb` | ソース | コマンドラインデマクサ設定画面 |
| Package.vb | `Source/General/Package.vb` | ソース | パッケージ情報の管理、Package.Items辞書 |
| Msg.vb | `Source/UI/Msg.vb` | ソース | MsgWarn等の通知表示関数 |
| PluginPackage.vb | `Source/General/Package.vb` | ソース | プラグインパッケージクラス（Package継承） |
