# 通知設計書 85-設定リセット確認

## 概要

本ドキュメントは、StaxRipアプリケーションにおける設定リセット確認ダイアログの設計仕様を定義します。この通知は、設定ファイルの読み込みに失敗した際に、ユーザーが「Reset」を選択した場合に表示される確認ダイアログです。

### 本通知の処理概要

**業務上の目的・背景**：StaxRipは複雑な設定情報を持つアプリケーションであり、設定ファイルが破損したり、互換性のないバージョンの設定ファイルを読み込もうとした場合にエラーが発生する可能性があります。設定リセット確認ダイアログは、設定ファイルの読み込みエラーが発生した際に、ユーザーが設定をリセットする前に最終確認を行うための機能です。これにより、ユーザーが意図しない設定の消失を防ぎ、慎重な判断を促します。

**通知の送信タイミング**：GlobalClass.LoadSettingsメソッドで設定ファイルの読み込みに失敗し、エラーダイアログで「Reset」ボタンが選択された後に、確認のために表示されます。

**通知の受信者**：アプリケーションを操作している現在のユーザー（GUI上でダイアログとして表示）。

**通知内容の概要**：「Are you sure you want to reset your settings? Your current settings will be lost!」という確認メッセージを表示し、設定リセットの最終確認を求めます。

**期待されるアクション**：ユーザーはOK（リセット実行）またはCancel（リセット中止）を選択します。OKを選択した場合は設定が初期化され、Cancelを選択した場合は設定読み込みが再試行されます。

## 通知種別

アプリ内通知（TaskDialogによるモーダルダイアログ - 質問ダイアログ）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期 |
| 優先度 | 高 |
| リトライ | なし |

### 送信先決定ロジック

現在操作中のユーザーに対して、GUIのモーダルダイアログとして直接表示します。送信先の決定ロジックは不要で、常にアクティブなウィンドウの前面に表示されます。

## 通知テンプレート

### ダイアログ通知の場合

| 項目 | 内容 |
|-----|------|
| ダイアログ種別 | MsgQuestion（質問ダイアログ） |
| アイコン | Question |
| タイトル | アプリケーション名（StaxRip） |
| ボタン | OK / Cancel |

### 本文テンプレート

```
Are you sure you want to reset your settings? Your current settings will be lost!
```

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| なし | - | - | 本通知に添付ファイルはありません |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| なし | 本通知は固定メッセージのため変数を使用しません | - | - |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| システム処理 | 設定読み込みエラー後のResetボタン選択 | LoadSettings例外発生後にResetが選択された場合 | ユーザーが設定リセットを選択した場合の確認 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| Retry選択 | 設定読み込みエラーダイアログでRetryを選択した場合、確認なしで再試行 |
| Exit選択 | 設定読み込みエラーダイアログでExitを選択した場合、アプリケーション終了 |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[LoadSettings実行] --> B{例外発生?}
    B -->|No| C[正常完了]
    B -->|Yes| D[エラーダイアログ表示<br>Retry/Reset/Exit]
    D --> E{ユーザー選択}
    E -->|Retry| A
    E -->|Exit| F[アプリケーション終了]
    E -->|Reset| G[MsgQuestion表示:<br>リセット確認]
    G --> H{確認結果}
    H -->|OK| I[新しいApplicationSettings作成]
    I --> J[s.Init実行]
    J --> C
    H -->|Cancel| A
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| なし | 本機能はデータベースを使用しません | ファイルベースの設定管理 |

### テーブル別参照項目詳細

本機能はデータベースを使用せず、設定ファイル（ApplicationSettings）を操作します。

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| なし | - | 設定ファイルをリセット |

#### 設定ファイル更新詳細

| 操作 | 項目 | 更新値 | 備考 |
|-----|------|-------|------|
| RESET | ApplicationSettings | 新しいインスタンス | s = New ApplicationSettingsで初期化 |
| INIT | ApplicationSettings | デフォルト値 | s.Init()で初期値を設定 |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| 設定読み込みエラー | 設定ファイルの破損、互換性エラー等 | TaskDialogでRetry/Reset/Exitを選択させる |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | ユーザー判断（Retryボタン） |
| リトライ間隔 | 即時 |
| リトライ対象エラー | 設定読み込みエラー |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | なし（システムイベントによる同期通知） |
| 1日あたり上限 | なし |

### 配信時間帯

制限なし。アプリケーション起動時のエラー発生に応じて即座に表示されます。

## セキュリティ考慮事項

- 設定リセットは破壊的な操作のため、二重確認を実装しています
- リセット後の設定は新しいインスタンスとして初期化されます
- 元の設定ファイルはリセット時に上書きされます

## 備考

- 設定リセット確認でCancelを選択した場合、設定読み込みが再試行されます
- OKを選択した場合、新しいApplicationSettingsインスタンスが作成され、デフォルト値で初期化されます
- この確認ダイアログは、ユーザーの重要なカスタマイズ設定の意図しない消失を防ぐためのセーフティネットです
- 設定ファイルの場所はGlobalClass.SettingsFileプロパティで定義されています

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | ApplicationSettings.vb | `Source/General/ApplicationSettings.vb` | ApplicationSettingsクラスの構造、Init()メソッドの初期化処理 |

**読解のコツ**: ApplicationSettingsはアプリケーション全体の設定を保持するクラスで、シリアライズ可能な形式で保存されます。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | GlobalClass.vb | `Source/General/GlobalClass.vb` | LoadSettingsメソッドが処理の起点 |

**主要処理フロー**:
1. **行84-90**: Mutexを使用した排他制御でのデシリアライズ
2. **行91-113**: 例外発生時のCatch節でTaskDialogを表示
3. **行100-109**: ユーザー選択に応じた処理分岐

#### Step 3: 確認ダイアログの表示を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | GlobalClass.vb | `Source/General/GlobalClass.vb` | 行103-109のResetケース処理 |

**主要処理フロー**:
- **行104**: MsgQuestion("Are you sure you want to reset your settings?...")を呼び出し
- **行105-106**: DialogResult.OKの場合、新しいApplicationSettingsインスタンスを作成してInit()
- **行107-108**: Cancelの場合、LoadSettings()を再帰呼び出し

#### Step 4: 通知表示の仕組みを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | Msg.vb | `Source/UI/Msg.vb` | MsgQuestion関数の実装、TaskDialogを使用した質問ダイアログ表示 |

### プログラム呼び出し階層図

```
GlobalClass.LoadSettings (行84)
    │
    ├─ SafeSerialization.Deserialize() (行88)
    │      └─ [例外発生時]
    │
    └─ Catch ex As Exception (行91)
           │
           ├─ TaskDialog.Show() (行100)
           │      │
           │      ├─ Case "Retry" → LoadSettings() [再帰]
           │      │
           │      ├─ Case "Reset"
           │      │      └─ MsgQuestion("Are you sure...") (行104)
           │      │             ├─ DialogResult.OK
           │      │             │      ├─ s = New ApplicationSettings (行105)
           │      │             │      └─ s.Init() (行106)
           │      │             └─ DialogResult.Cancel
           │      │                    └─ LoadSettings() [再帰] (行108)
           │      │
           │      └─ Case Else → Process.Kill() (行111)
```

### データフロー図

```
[入力]                      [処理]                           [出力]

設定ファイル ──────────▶ Deserialize() ───▶ 例外発生
                                │
                                ▼
                          TaskDialog ─────▶ Reset選択
                                │
                                ▼
                          MsgQuestion() ──▶ 確認ダイアログ
                                │
                                ├──▶ OK: New ApplicationSettings → 初期化された設定
                                │
                                └──▶ Cancel: LoadSettings() → 再試行
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| GlobalClass.vb | `Source/General/GlobalClass.vb` | ソース | 設定読み込み、LoadSettingsメソッド |
| ApplicationSettings.vb | `Source/General/ApplicationSettings.vb` | ソース | アプリケーション設定クラス |
| SafeSerialization.vb | `Source/General/SafeSerialization.vb` | ソース | 安全なシリアライズ/デシリアライズ処理 |
| Msg.vb | `Source/UI/Msg.vb` | ソース | MsgQuestion等の通知表示関数 |
| TaskDialog.vb | `Source/UI/TaskDialog.vb` | ソース | TaskDialogラッパークラス |
