# 通知設計書 86-ファイル削除確認

## 概要

本ドキュメントは、StaxRipアプリケーションにおけるファイル削除確認ダイアログの設計仕様を定義します。この通知は、ツール更新処理（ToolUpdate）において、新しいバージョンのツールをインストールする前に、既存のファイルを削除するかどうかをユーザーに確認するダイアログです。

### 本通知の処理概要

**業務上の目的・背景**：StaxRipはffmpeg、mkvtoolnix等の外部ツールに依存しており、これらのツールを更新する機能を提供しています。ファイル削除確認ダイアログは、ツール更新プロセスの一部として、既存のツールファイルを削除する前にユーザーの明示的な同意を得るための機能です。これにより、ユーザーが意図しないファイル削除を防ぎ、更新プロセスの透明性を確保します。

**通知の送信タイミング**：ToolUpdateクラスのDeleteOldFilesメソッドで、新しいツールのダウンロードと抽出が完了した後、既存ファイルの削除処理を開始する前に表示されます。

**通知の受信者**：アプリケーションを操作している現在のユーザー（GUI上でダイアログとして表示）。

**通知内容の概要**：「Delete current files?」というタイトルと、削除対象のディレクトリとファイル一覧を表示し、ユーザーに削除の確認を求めます。

**期待されるアクション**：ユーザーはOK（削除実行）またはCancel（削除中止）を選択します。OKを選択した場合はファイルがゴミ箱に移動され、更新処理が続行されます。Cancelを選択した場合は更新処理がキャンセルされます。

## 通知種別

アプリ内通知（TaskDialogによるモーダルダイアログ - 質問ダイアログ）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期 |
| 優先度 | 高 |
| リトライ | なし |

### 送信先決定ロジック

現在操作中のユーザーに対して、GUIのモーダルダイアログとして直接表示します。送信先の決定ロジックは不要で、常にアクティブなウィンドウの前面に表示されます。

## 通知テンプレート

### ダイアログ通知の場合

| 項目 | 内容 |
|-----|------|
| ダイアログ種別 | MsgQuestion（質問ダイアログ） |
| アイコン | Question |
| タイトル | Delete current files? |
| ボタン | OK / Cancel |

### 本文テンプレート

```
Delete current files in:

{TargetDir}

{fileList}
```

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| なし | - | - | 本通知に添付ファイルはありません |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| {TargetDir} | 削除対象のディレクトリパス | ToolUpdate.TargetDir | Yes |
| {fileList} | 削除対象のファイル名一覧（改行区切り） | Directory.GetFileSystemEntries() | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| システム処理 | ツール更新時のファイル削除前 | ダウンロードと抽出が正常完了した場合 | ToolUpdate.DeleteOldFilesメソッド呼び出し時 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| ダウンロード失敗 | ダウンロードが失敗した場合、このダイアログには到達しない |
| 抽出失敗 | 抽出が失敗した場合、このダイアログには到達しない |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[ダウンロード完了] --> B[ファイル抽出]
    B --> C[DeleteOldFiles呼び出し]
    C --> D[削除対象ファイル一覧を取得]
    D --> E[Package.Keepに含まれるファイルを除外]
    E --> F[MsgQuestion表示:<br>Delete current files?]
    F --> G{ユーザー選択}
    G -->|OK| H[ファイルをゴミ箱に移動]
    H --> I[フォルダをゴミ箱に移動]
    I --> J[CopyFilesへ進む]
    G -->|Cancel| K[MsgInfo: Update was canceled]
    K --> L[処理終了]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| なし | 本機能はデータベースを使用しません | ファイルシステムを直接操作 |

### テーブル別参照項目詳細

本機能はデータベースを使用せず、ファイルシステムを直接操作します。

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| なし | - | ファイルシステム操作 |

#### ファイルシステム操作詳細

| 操作 | 対象 | 処理内容 | 備考 |
|-----|------|---------|------|
| DELETE | TargetDir内のファイル | FileHelp.Delete（ゴミ箱へ移動） | Package.Keep対象ファイルは除外 |
| DELETE | TargetDir内のフォルダ | FolderHelp.Delete（ゴミ箱へ移動） | Package.Keep対象フォルダは除外 |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| ファイル削除エラー | ファイルがロックされている等 | 例外がスローされ、更新処理が中断される |
| キャンセル | ユーザーがCancelを選択 | MsgInfo「Update was canceled.」を表示して終了 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | - |
| リトライ対象エラー | - |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | なし（ユーザー操作による同期通知） |
| 1日あたり上限 | なし |

### 配信時間帯

制限なし。ツール更新操作に応じて即座に表示されます。

## セキュリティ考慮事項

- ファイル削除は物理削除ではなく、ゴミ箱への移動（RecycleOption.SendToRecycleBin）で実行されます
- Package.Keepに登録されたファイル（設定ファイル等）は削除から除外されます
- ユーザーの明示的な同意なしに削除は実行されません

## 備考

- ファイルはゴミ箱に移動されるため、誤って削除した場合でも復元可能です
- Package.Keepリストにより、ユーザーのカスタマイズ設定ファイル等を保護します
- 関連する通知として「ファイルコピー確認」（No.87）、「更新キャンセル通知」（No.13）があります
- 削除処理の後、CopyFilesメソッドで新しいファイルのコピーが行われます

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | ToolUpdate.vb | `Source/General/ToolUpdate.vb` | ToolUpdateクラスの構造、TargetDir、ExtractDir等のプロパティ |
| 1-2 | Package.vb | `Source/General/Package.vb` | Package.Keepプロパティ（削除対象外ファイルのリスト） |

**読解のコツ**: ToolUpdateクラスはツールの更新処理全体を管理し、ダウンロード→抽出→削除→コピーの一連のフローを制御しています。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | ToolUpdate.vb | `Source/General/ToolUpdate.vb` | DeleteOldFilesメソッドが処理の起点 |

**主要処理フロー**:
1. **行127**: DeleteOldFilesメソッドの開始
2. **行128-131**: 対象ファイル一覧を取得し、Keep対象を除外
3. **行134-135**: MsgQuestionでユーザー確認

#### Step 3: ファイル削除処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | ToolUpdate.vb | `Source/General/ToolUpdate.vb` | 行134-156のファイル削除処理 |

**主要処理フロー**:
- **行134-135**: MsgQuestion("Delete current files?", ...)を呼び出し
- **行137-143**: ファイル削除ループ（Package.Keep対象は除外）
- **行145-151**: フォルダ削除ループ（Package.Keep対象は除外）
- **行152-155**: Cancelの場合、MsgInfo("Update was canceled.")を表示して終了

#### Step 4: 通知表示の仕組みを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | Msg.vb | `Source/UI/Msg.vb` | MsgQuestion関数の実装 |

### プログラム呼び出し階層図

```
ToolUpdate.DeleteOldFiles (行127)
    │
    ├─ Directory.GetFileSystemEntries(TargetDir) (行128)
    │
    ├─ entries.Where(Package.Keep除外) (行129)
    │
    ├─ MsgQuestion("Delete current files?", ...) (行134)
    │      │
    │      ├─ DialogResult.OK
    │      │      ├─ For Each file (行137)
    │      │      │      └─ FileHelp.Delete(file, RecycleBin) (行142)
    │      │      │
    │      │      ├─ For Each folder (行145)
    │      │      │      └─ FolderHelp.Delete(folder, RecycleBin) (行150)
    │      │      │
    │      │      └─ CopyFiles() (行158)
    │      │
    │      └─ DialogResult.Cancel
    │             └─ MsgInfo("Update was canceled.") (行154)
```

### データフロー図

```
[入力]                         [処理]                              [出力]

TargetDir ─────────────────▶ GetFileSystemEntries() ──▶ ファイル一覧
                                      │
Package.Keep ──────────────▶ Where除外処理 ───────────▶ 削除対象一覧
                                      │
                                      ▼
                              MsgQuestion() ──────────▶ 確認ダイアログ
                                      │
                                      ├──▶ OK: FileHelp.Delete → ゴミ箱
                                      │        FolderHelp.Delete
                                      │
                                      └──▶ Cancel: MsgInfo → 処理終了
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| ToolUpdate.vb | `Source/General/ToolUpdate.vb` | ソース | ツール更新処理全体の管理 |
| Package.vb | `Source/General/Package.vb` | ソース | パッケージ情報、Keepリスト |
| FileHelp.vb | `Source/General/FileHelp.vb` | ソース | ファイル操作ヘルパー |
| FolderHelp.vb | `Source/General/FolderHelp.vb` | ソース | フォルダ操作ヘルパー |
| Msg.vb | `Source/UI/Msg.vb` | ソース | MsgQuestion等の通知表示関数 |
