# 通知設計書 87-ファイルコピー確認

## 概要

本ドキュメントは、StaxRipアプリケーションにおけるファイルコピー確認ダイアログの設計仕様を定義します。この通知は、ツール更新処理（ToolUpdate）において、既存ファイルの削除後に新しいファイルをコピーするかどうかをユーザーに確認するダイアログです。

### 本通知の処理概要

**業務上の目的・背景**：StaxRipのツール更新処理では、ダウンロード→抽出→削除→コピーという一連のフローで外部ツールを更新します。ファイルコピー確認ダイアログは、新しいバージョンのファイルをインストール先にコピーする前にユーザーの最終確認を得るための機能です。これにより、ユーザーは更新内容を確認でき、問題がある場合は処理を中断できます。

**通知の送信タイミング**：ToolUpdateクラスのCopyFilesメソッドで、既存ファイルの削除が完了した後、新しいファイルのコピー処理を開始する前に表示されます。

**通知の受信者**：アプリケーションを操作している現在のユーザー（GUI上でダイアログとして表示）。

**通知内容の概要**：「Copy new files?」というタイトルと、コピー元ディレクトリ、コピー先ディレクトリ、ファイル一覧を表示し、ユーザーにコピーの確認を求めます。

**期待されるアクション**：ユーザーはOK（コピー実行）またはCancel（コピー中止）を選択します。OKを選択した場合はファイルがコピーされ、更新処理が完了します。Cancelを選択した場合は更新処理がキャンセルされます。

## 通知種別

アプリ内通知（TaskDialogによるモーダルダイアログ - 質問ダイアログ）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期 |
| 優先度 | 高 |
| リトライ | なし |

### 送信先決定ロジック

現在操作中のユーザーに対して、GUIのモーダルダイアログとして直接表示します。送信先の決定ロジックは不要で、常にアクティブなウィンドウの前面に表示されます。

## 通知テンプレート

### ダイアログ通知の場合

| 項目 | 内容 |
|-----|------|
| ダイアログ種別 | MsgQuestion（質問ダイアログ） |
| アイコン | Question |
| タイトル | Copy new files? |
| ボタン | OK / Cancel |

### 本文テンプレート

```
Copy new files from:

{ExtractDir}

to:

{TargetDir}

{fileList}
```

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| なし | - | - | 本通知に添付ファイルはありません |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| {ExtractDir} | コピー元のディレクトリパス（抽出先） | ToolUpdate.ExtractDir | Yes |
| {TargetDir} | コピー先のディレクトリパス（インストール先） | ToolUpdate.TargetDir | Yes |
| {fileList} | コピー対象のファイル名一覧（改行区切り） | Directory.GetFileSystemEntries() | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| システム処理 | ツール更新時の既存ファイル削除後 | ファイル削除が正常完了した場合 | ToolUpdate.CopyFilesメソッド呼び出し時 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| ファイル削除でキャンセル | ファイル削除確認でCancelを選択した場合、このダイアログには到達しない |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[DeleteOldFiles完了] --> B[CopyFiles呼び出し]
    B --> C[コピー対象ファイル一覧を取得]
    C --> D[MsgQuestion表示:<br>Copy new files?]
    D --> E{ユーザー選択}
    E -->|OK| F[ファイルをコピー]
    F --> G[フォルダをコピー]
    G --> H[抽出ディレクトリをゴミ箱へ移動]
    H --> I[EditVersionへ進む]
    E -->|Cancel| J[MsgInfo: Update was canceled]
    J --> K[処理終了]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| なし | 本機能はデータベースを使用しません | ファイルシステムを直接操作 |

### テーブル別参照項目詳細

本機能はデータベースを使用せず、ファイルシステムを直接操作します。

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| なし | - | ファイルシステム操作 |

#### ファイルシステム操作詳細

| 操作 | 対象 | 処理内容 | 備考 |
|-----|------|---------|------|
| COPY | ExtractDir内のファイル | FileHelp.Copy | TargetDirへコピー |
| COPY | ExtractDir内のフォルダ | FolderHelp.Copy | TargetDirへコピー |
| DELETE | ExtractDir | FolderHelp.Delete（ゴミ箱へ移動） | コピー完了後にクリーンアップ |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| ファイルコピーエラー | コピー先がロックされている等 | 例外がスローされ、更新処理が中断される |
| キャンセル | ユーザーがCancelを選択 | MsgInfo「Update was canceled.」を表示して終了 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | - |
| リトライ対象エラー | - |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | なし（ユーザー操作による同期通知） |
| 1日あたり上限 | なし |

### 配信時間帯

制限なし。ツール更新操作に応じて即座に表示されます。

## セキュリティ考慮事項

- コピー処理はユーザーの明示的な同意後に実行されます
- コピー完了後、抽出ディレクトリはゴミ箱に移動されます（クリーンアップ）
- コピー先のファイルは上書きされます

## 備考

- コピー処理後、抽出ディレクトリは自動的にゴミ箱に移動されます
- 関連する通知として「ファイル削除確認」（No.86）、「更新キャンセル通知」（No.13）があります
- コピー処理の後、EditVersionメソッドでバージョン情報の編集が行われます
- コピー元はダウンロードファイルの抽出先、コピー先はツールのインストールディレクトリです

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | ToolUpdate.vb | `Source/General/ToolUpdate.vb` | ToolUpdateクラスの構造、ExtractDir、TargetDir等のプロパティ |

**読解のコツ**: ExtractDirはダウンロードファイルの抽出先、TargetDirはツールの最終インストール先です。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | ToolUpdate.vb | `Source/General/ToolUpdate.vb` | CopyFilesメソッドが処理の起点 |

**主要処理フロー**:
1. **行161**: CopyFilesメソッドの開始
2. **行162-164**: 対象ファイル一覧を取得
3. **行167-169**: MsgQuestionでユーザー確認

#### Step 3: ファイルコピー処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | ToolUpdate.vb | `Source/General/ToolUpdate.vb` | 行167-186のファイルコピー処理 |

**主要処理フロー**:
- **行167-169**: MsgQuestion("Copy new files?", ...)を呼び出し
- **行171-173**: ファイルコピーループ
- **行175-177**: フォルダコピーループ
- **行178-181**: Cancelの場合、MsgInfo("Update was canceled.")を表示して終了
- **行184**: 抽出ディレクトリをゴミ箱に移動

#### Step 4: 通知表示の仕組みを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | Msg.vb | `Source/UI/Msg.vb` | MsgQuestion関数の実装 |

### プログラム呼び出し階層図

```
ToolUpdate.CopyFiles (行161)
    │
    ├─ Directory.GetFileSystemEntries(ExtractDir) (行162)
    │
    ├─ MsgQuestion("Copy new files?", ...) (行167)
    │      │
    │      ├─ DialogResult.OK
    │      │      ├─ For Each file (行171)
    │      │      │      └─ FileHelp.Copy(file, TargetDir) (行172)
    │      │      │
    │      │      ├─ For Each folder (行175)
    │      │      │      └─ FolderHelp.Copy(folder, TargetDir) (行176)
    │      │      │
    │      │      ├─ FolderHelp.Delete(ExtractDir, RecycleBin) (行184)
    │      │      │
    │      │      └─ EditVersion() (行185)
    │      │
    │      └─ DialogResult.Cancel
    │             └─ MsgInfo("Update was canceled.") (行180)
```

### データフロー図

```
[入力]                         [処理]                              [出力]

ExtractDir ────────────────▶ GetFileSystemEntries() ──▶ ファイル一覧
                                      │
                                      ▼
                              MsgQuestion() ──────────▶ 確認ダイアログ
                                      │
                                      ├──▶ OK: FileHelp.Copy → TargetDirへコピー
                                      │        FolderHelp.Copy
                                      │        FolderHelp.Delete(ExtractDir)
                                      │
                                      └──▶ Cancel: MsgInfo → 処理終了
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| ToolUpdate.vb | `Source/General/ToolUpdate.vb` | ソース | ツール更新処理全体の管理 |
| FileHelp.vb | `Source/General/FileHelp.vb` | ソース | ファイル操作ヘルパー |
| FolderHelp.vb | `Source/General/FolderHelp.vb` | ソース | フォルダ操作ヘルパー |
| Msg.vb | `Source/UI/Msg.vb` | ソース | MsgQuestion等の通知表示関数 |
