# 通知設計書 88-エラーログ確認

## 概要

本ドキュメントは、StaxRipアプリケーションにおけるエラーログ確認ダイアログの設計仕様を定義します。この通知は、アプリケーションで例外エラーが発生した際に、ログファイルを開くかどうかをユーザーに確認するダイアログです。

### 本通知の処理概要

**業務上の目的・背景**：StaxRipはビデオエンコーディングという複雑な処理を行うアプリケーションであり、様々なエラーが発生する可能性があります。エラーログ確認ダイアログは、エラー発生時にユーザーが詳細なログ情報を確認できるようにするための機能です。ログファイルにはエラーの詳細な情報が記録されており、問題の診断やバグレポートの作成に役立ちます。

**通知の送信タイミング**：GlobalClassのMakeBugReportメソッドで、例外情報がログに記録された後、バグレポート作成プロセスの一部として表示されます。

**通知の受信者**：アプリケーションを操作している現在のユーザー（GUI上でダイアログとして表示）。

**通知内容の概要**：「An error occured」というタイトルと「Do you want to open the log file?」という確認メッセージを表示し、ログファイルを開くかどうかをユーザーに確認します。

**期待されるアクション**：ユーザーはYes（ログファイルを開く）またはNo（開かない）を選択します。Yesを選択した場合はテキストエディタでログファイルが開かれます。

## 通知種別

アプリ内通知（TaskDialogによるモーダルダイアログ - 質問ダイアログ）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期 |
| 優先度 | 高 |
| リトライ | なし |

### 送信先決定ロジック

現在操作中のユーザーに対して、GUIのモーダルダイアログとして直接表示します。送信先の決定ロジックは不要で、常にアクティブなウィンドウの前面に表示されます。

## 通知テンプレート

### ダイアログ通知の場合

| 項目 | 内容 |
|-----|------|
| ダイアログ種別 | MsgQuestion（質問ダイアログ） |
| アイコン | Question |
| タイトル | An error occured |
| ボタン | Yes / No |

### 本文テンプレート

```
Do you want to open the log file?
```

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| なし | - | - | 本通知に添付ファイルはありません（ログファイルは外部で開く） |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| なし | 本通知は固定メッセージのため変数を使用しません | - | - |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| システム処理 | 例外発生後のバグレポート処理 | MakeBugReportメソッドが呼び出された場合 | エラー発生時のログ確認フロー |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| 例外がnullかつソースが無効 | e Is Nothing AndAlso Not g.IsValidSource(False)の場合、処理がスキップされる |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[MakeBugReport呼び出し] --> B{例外またはソースが有効?}
    B -->|No| C[処理終了]
    B -->|Yes| D[例外情報をログに記録]
    D --> E[Log.Save実行]
    E --> F[MsgQuestion表示:<br>Do you want to open the log file?]
    F --> G{ユーザー選択}
    G -->|Yes| H[テキストエディタでログを開く]
    H --> I[logfileOpened = True]
    I --> J[バグレポート確認へ]
    G -->|No| J
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| なし | 本機能はデータベースを使用しません | ログファイルを直接操作 |

### テーブル別参照項目詳細

本機能はデータベースを使用せず、ログファイルを操作します。

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| なし | - | ログファイルへの書き込みはMakeBugReport前に完了 |

#### ログファイル操作詳細

| 操作 | ファイル | 処理内容 | 備考 |
|-----|---------|---------|------|
| WRITE | Log.GetPath | 例外情報を含むログを保存 | Log.Save(p)で実行 |
| READ | Log.GetPath | テキストエディタで開く | g.ShellExecuteで実行 |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| テキストエディタ起動失敗 | エディタが見つからない等 | 例外がスローされる可能性あり |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | - |
| リトライ対象エラー | - |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | なし（エラー発生時のみ） |
| 1日あたり上限 | なし |

### 配信時間帯

制限なし。エラー発生に応じて即座に表示されます。

## セキュリティ考慮事項

- ログファイルには例外のスタックトレース等の技術情報が含まれます
- ログファイルはユーザーのローカルディスクに保存されます
- 外部に送信する前にユーザーの同意が必要です（バグレポート確認で対応）

## 備考

- このダイアログの後に「バグレポート確認」（No.89）ダイアログが表示されます
- Yesを選択した場合、logfileOpenedフラグがTrueに設定され、後続のバグレポート処理で参照されます
- ログファイルはg.GetTextEditorPath()で取得されたテキストエディタで開かれます
- ログファイルのパスはLog.GetPathで取得されます

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Log.vb | `Source/General/Log.vb` | Logクラスの構造、GetPathプロパティ、Saveメソッド |

**読解のコツ**: Logクラスはアプリケーションのログ管理を担当し、ファイルパスの取得やログの保存機能を提供します。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | GlobalClass.vb | `Source/General/GlobalClass.vb` | MakeBugReportメソッドが処理の起点 |

**主要処理フロー**:
1. **行1609**: MakeBugReportメソッドの開始
2. **行1610-1612**: 例外とソースの有効性チェック
3. **行1614-1618**: 例外情報をログに記録
4. **行1620**: Log.Save(p)でログを保存

#### Step 3: ログファイル確認ダイアログを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | GlobalClass.vb | `Source/General/GlobalClass.vb` | 行1622-1630のログ確認処理 |

**主要処理フロー**:
- **行1622**: logfileOpenedフラグの初期化
- **行1623**: ログファイルパスの取得
- **行1625-1626**: MsgQuestion("An error occured", "Do you want to open the log file?", TaskButton.YesNo)
- **行1628**: g.ShellExecuteでテキストエディタを起動
- **行1629**: logfileOpened = True

#### Step 4: 通知表示の仕組みを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | Msg.vb | `Source/UI/Msg.vb` | MsgQuestion関数の実装、TaskButton.YesNoオプション |

### プログラム呼び出し階層図

```
GlobalClass.MakeBugReport (行1609)
    │
    ├─ If e Is Nothing AndAlso Not g.IsValidSource(False) (行1610)
    │      └─ Exit Sub [条件成立時]
    │
    ├─ Log.WriteHeader("Exception") (行1616)
    │      └─ Log.WriteLine(e.ToString) (行1617)
    │
    ├─ Log.Save(p) (行1620)
    │
    ├─ MsgQuestion("An error occured", "Do you want to open the log file?", ...) (行1625)
    │      │
    │      ├─ DialogResult.Yes
    │      │      ├─ g.ShellExecute(g.GetTextEditorPath(), fp.Escape) (行1628)
    │      │      └─ logfileOpened = True (行1629)
    │      │
    │      └─ DialogResult.No
    │             └─ [何もしない]
    │
    └─ MsgQuestion("Bug Report", ...) (行1632) [後続処理]
```

### データフロー図

```
[入力]                         [処理]                              [出力]

Exception e ─────────────────▶ Log.WriteHeader/WriteLine ──▶ ログファイル
                                      │
                                      ▼
                              Log.Save(p) ────────────────▶ ファイル保存
                                      │
                                      ▼
                              MsgQuestion() ──────────────▶ 確認ダイアログ
                                      │
                                      ├──▶ Yes: ShellExecute → テキストエディタ
                                      │
                                      └──▶ No: [次の処理へ]
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| GlobalClass.vb | `Source/General/GlobalClass.vb` | ソース | MakeBugReportメソッド、エラー処理全体の管理 |
| Log.vb | `Source/General/Log.vb` | ソース | ログ管理クラス |
| Msg.vb | `Source/UI/Msg.vb` | ソース | MsgQuestion等の通知表示関数 |
