# 通知設計書 89-バグレポート確認

## 概要

本ドキュメントは、StaxRipアプリケーションにおけるバグレポート確認ダイアログの設計仕様を定義します。この通知は、アプリケーションで例外エラーが発生した際に、GitHubのIssuesページでバグレポートを作成するかどうかをユーザーに確認するダイアログです。

### 本通知の処理概要

**業務上の目的・背景**：StaxRipはオープンソースプロジェクトであり、ユーザーからのバグレポートは品質改善に不可欠です。バグレポート確認ダイアログは、エラー発生時にユーザーが簡単にバグレポートを作成できるようにするための機能です。ユーザーがYesを選択すると、ログファイルを開き、GitHubのIssuesページをブラウザで開いて、バグレポートの作成を支援します。

**通知の送信タイミング**：GlobalClassのMakeBugReportメソッドで、ログファイル確認ダイアログの後に表示されます。

**通知の受信者**：アプリケーションを操作している現在のユーザー（GUI上でダイアログとして表示）。

**通知内容の概要**：「Bug Report」というタイトルと「Do you want to report an issue or bug?」という確認メッセージを表示し、バグレポートを作成するかどうかをユーザーに確認します。

**期待されるアクション**：ユーザーはYes（バグレポート作成）またはNo（作成しない）を選択します。Yesを選択した場合、ログファイルがまだ開かれていなければ開き、エクスプローラーでログファイルを選択状態にし、GitHubのIssuesページを開きます。

## 通知種別

アプリ内通知（TaskDialogによるモーダルダイアログ - 質問ダイアログ）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期 |
| 優先度 | 中 |
| リトライ | なし |

### 送信先決定ロジック

現在操作中のユーザーに対して、GUIのモーダルダイアログとして直接表示します。送信先の決定ロジックは不要で、常にアクティブなウィンドウの前面に表示されます。

## 通知テンプレート

### ダイアログ通知の場合

| 項目 | 内容 |
|-----|------|
| ダイアログ種別 | MsgQuestion（質問ダイアログ） |
| アイコン | Question |
| タイトル | Bug Report |
| ボタン | Yes / No |

### 本文テンプレート

```
Do you want to report an issue or bug?
```

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| なし | - | - | 本通知に添付ファイルはありません |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| なし | 本通知は固定メッセージのため変数を使用しません | - | - |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| システム処理 | エラーログ確認ダイアログの後 | MakeBugReportメソッドが呼び出された場合 | エラー発生時のバグレポート作成フロー |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| 前のダイアログで処理が中断された場合 | ログファイル確認ダイアログの処理が正常に完了した後にのみ表示 |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[エラーログ確認完了] --> B[MsgQuestion表示:<br>Do you want to report an issue or bug?]
    B --> C{ユーザー選択}
    C -->|Yes| D{logfileOpenedがFalse?}
    D -->|Yes| E[テキストエディタでログを開く]
    E --> F[エクスプローラーでログファイルを選択]
    D -->|No| F
    F --> G[GitHubのIssuesページを開く]
    G --> H[処理終了]
    C -->|No| H
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| なし | 本機能はデータベースを使用しません | 外部リソースへのアクセス |

### テーブル別参照項目詳細

本機能はデータベースを使用しません。

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| なし | - | データの更新は行わない |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| ブラウザ起動失敗 | デフォルトブラウザが設定されていない等 | 例外がスローされる可能性あり |
| エクスプローラー起動失敗 | システムエラー | 例外がスローされる可能性あり |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | - |
| リトライ対象エラー | - |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | なし（エラー発生時のみ） |
| 1日あたり上限 | なし |

### 配信時間帯

制限なし。エラー発生に応じて即座に表示されます。

## セキュリティ考慮事項

- バグレポートの内容はユーザーがGitHub上で入力します
- ログファイルの内容をユーザーが確認してからレポートに含めることができます
- 個人情報や機密情報が含まれていないかユーザーが確認できる設計です

## 備考

- このダイアログは「エラーログ確認」（No.88）ダイアログの後に表示されます
- Yesを選択した場合、複数のアクションが実行されます：
  1. ログファイルをテキストエディタで開く（まだ開かれていない場合）
  2. エクスプローラーでログファイルを選択状態にする
  3. GitHubのIssuesページを開く
- GitHubのIssuesページのURLは `https://github.com/staxrip/staxrip/issues` です
- logfileOpenedフラグにより、ログファイルの二重オープンを防止しています

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | GlobalClass.vb | `Source/General/GlobalClass.vb` | logfileOpenedフラグの役割、MakeBugReportメソッドの全体構造 |

**読解のコツ**: logfileOpenedは前のダイアログでログファイルを開いたかどうかを追跡するフラグです。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | GlobalClass.vb | `Source/General/GlobalClass.vb` | MakeBugReportメソッド内のバグレポート確認処理 |

**主要処理フロー**:
1. **行1622-1630**: エラーログ確認処理（前処理）
2. **行1632-1633**: バグレポート確認ダイアログ表示

#### Step 3: バグレポート確認処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | GlobalClass.vb | `Source/General/GlobalClass.vb` | 行1632-1641のバグレポート確認処理 |

**主要処理フロー**:
- **行1632-1633**: MsgQuestion("Bug Report", "Do you want to report an issue or bug?", TaskButton.YesNo)
- **行1635-1637**: logfileOpenedがFalseの場合、テキストエディタでログを開く
- **行1639**: g.SelectFileWithExplorerでログファイルをエクスプローラーで選択
- **行1640**: g.ShellExecuteでGitHubのIssuesページを開く

#### Step 4: 通知表示の仕組みを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | Msg.vb | `Source/UI/Msg.vb` | MsgQuestion関数の実装、TaskButton.YesNoオプション |

### プログラム呼び出し階層図

```
GlobalClass.MakeBugReport (行1609)
    │
    ├─ [エラーログ確認処理] (行1625-1630)
    │
    └─ MsgQuestion("Bug Report", "Do you want to report an issue or bug?", ...) (行1632)
           │
           ├─ DialogResult.Yes
           │      ├─ If Not logfileOpened (行1635)
           │      │      └─ g.ShellExecute(g.GetTextEditorPath(), fp.Escape) (行1636)
           │      │
           │      ├─ g.SelectFileWithExplorer(fp) (行1639)
           │      │
           │      └─ g.ShellExecute("https://github.com/staxrip/staxrip/issues") (行1640)
           │
           └─ DialogResult.No
                  └─ [何もしない]
```

### データフロー図

```
[入力]                         [処理]                              [出力]

logfileOpened ─────────────▶ 条件チェック ─────────────▶ ログファイルオープン（必要時）
                                   │
Log.GetPath (fp) ──────────▶ SelectFileWithExplorer ──▶ エクスプローラー表示
                                   │
                                   ▼
GitHubのURL ─────────────────▶ ShellExecute ───────────▶ ブラウザで開く
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| GlobalClass.vb | `Source/General/GlobalClass.vb` | ソース | MakeBugReportメソッド、エラー処理全体の管理 |
| Msg.vb | `Source/UI/Msg.vb` | ソース | MsgQuestion等の通知表示関数 |
| g.SelectFileWithExplorer | `Source/General/GlobalClass.vb` | メソッド | エクスプローラーでファイルを選択状態にする |
| g.ShellExecute | `Source/General/GlobalClass.vb` | メソッド | 外部プログラムまたはURLを開く |
