# 通知設計書 90-入力形式非対応警告

## 概要

本ドキュメントは、StaxRipアプリケーションにおける入力形式非対応警告の設計仕様を定義します。この通知は、オーディオ設定画面（AudioForm）で、選択したオーディオエンコーダが入力ファイルの形式をサポートしていない場合に表示される警告通知です。

### 本通知の処理概要

**業務上の目的・背景**：StaxRipは様々なオーディオエンコーダ（AAC、MP3、FLAC等）をサポートしており、各エンコーダは特定の入力形式のみを受け付けます。入力形式非対応警告は、ユーザーが選択したエンコーダが現在の入力ファイル形式をサポートしていないことを通知し、適切な対処方法（WAVまたはFLACへの変換、パイプ処理の有効化）を案内するための機能です。

**通知の送信タイミング**：AudioFormのExecuteメソッドで、オーディオエンコード処理を開始しようとした際に、入力形式がサポートされておらず、かつパイプ処理が有効でない場合に表示されます。

**通知の受信者**：アプリケーションを操作している現在のユーザー（GUI上でダイアログとして表示）。

**通知内容の概要**：「The input format isn't supported by the current encoder, convert to WAV or FLAC first or enable piping in the options.」という警告メッセージを表示し、解決策を案内します。

**期待されるアクション**：ユーザーは以下のいずれかの対処を行います：
1. 入力ファイルをWAVまたはFLAC形式に変換する
2. オプションでパイプ処理を有効にする
3. 入力形式をサポートしているエンコーダに変更する

## 通知種別

アプリ内通知（TaskDialogによるモーダルダイアログ - 警告通知）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期 |
| 優先度 | 中 |
| リトライ | なし |

### 送信先決定ロジック

現在操作中のユーザーに対して、GUIのモーダルダイアログとして直接表示します。送信先の決定ロジックは不要で、常にアクティブなウィンドウの前面に表示されます。

## 通知テンプレート

### ダイアログ通知の場合

| 項目 | 内容 |
|-----|------|
| ダイアログ種別 | MsgWarn（警告通知） |
| アイコン | Warning |
| タイトル | アプリケーション名（StaxRip） |
| ボタン | OK |

### 本文テンプレート

```
The input format isn't supported by the current encoder,
convert to WAV or FLAC first or enable piping in the options.
```

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| なし | - | - | 本通知に添付ファイルはありません |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| なし | 本通知は固定メッセージのため変数を使用しません | - | - |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 画面操作 | AudioFormでエンコード実行 | TempProfile.IsInputSupportedがFalse かつ TempProfile.DecodingModeがPipeでない | オーディオエンコード実行時に入力形式が非対応の場合 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| 入力形式がサポートされている | TempProfile.IsInputSupportedがTrueの場合、警告なしでエンコード処理が実行される |
| パイプ処理が有効 | TempProfile.DecodingModeがAudioDecodingMode.Pipeの場合、警告なしでエンコード処理が実行される |
| ファイルが未選択 | TempProfile.Fileが空の場合、別の警告（ソースファイル不在警告）が表示される |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[Executeメソッド呼び出し] --> B{TempProfile.Fileが空?}
    B -->|Yes| C[MsgWarn: Source file is missing!]
    C --> D[終了]
    B -->|No| E{IsInputSupported?}
    E -->|Yes| F[エンコード処理実行]
    F --> D
    E -->|No| G{DecodingMode = Pipe?}
    G -->|Yes| F
    G -->|No| H[MsgWarn表示:<br>入力形式非対応警告]
    H --> D
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| なし | 本機能はデータベースを使用しません | オーディオプロファイル情報を参照 |

### テーブル別参照項目詳細

本機能はデータベースを使用せず、メモリ上のAudioProfile（TempProfile）オブジェクトを参照します。

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| なし | - | 本機能はデータを更新しません |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| 入力形式非対応 | IsInputSupportedがFalseかつPipeでない | MsgWarnで警告メッセージを表示 |
| ソースファイル不在 | TempProfile.Fileが空 | MsgWarn「Source file is missing!」を表示 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | - |
| リトライ対象エラー | - |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | なし（ユーザー操作による同期通知） |
| 1日あたり上限 | なし |

### 配信時間帯

制限なし。ユーザー操作に応じて即座に表示されます。

## セキュリティ考慮事項

- 読み取り専用の操作であり、システムに変更を加えません
- ユーザーのオーディオファイルパスは表示されません

## 備考

- この警告はオーディオエンコードを中断させるためのものであり、ユーザーが適切な対処を行った後に再試行できます
- 対処方法は以下の3つ：
  1. 入力ファイルをWAVまたはFLAC形式に事前変換
  2. オプションでパイプ処理（AudioDecodingMode.Pipe）を有効化
  3. 入力形式をサポートしているエンコーダに変更
- 関連する通知として「ソースファイル不在警告」（No.91）があります
- BR定数（改行）を使用してメッセージ内で改行しています

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | AudioProfile.vb | `Source/Audio/AudioProfile.vb` | AudioProfileクラス、IsInputSupportedプロパティ、DecodingModeプロパティ |

**読解のコツ**: IsInputSupportedは入力ファイルの形式がエンコーダでサポートされているかを判定するプロパティです。DecodingModeはデコード方法を指定する列挙型です。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | AudioForm.vb | `Source/Forms/AudioForm.vb` | Executeメソッドが処理の起点 |

**主要処理フロー**:
1. **行1654**: Executeメソッドの開始
2. **行1655**: TempProfile.Fileの空チェック
3. **行1656-1657**: 入力形式サポートチェックとパイプモードチェック

#### Step 3: 警告表示処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | AudioForm.vb | `Source/Forms/AudioForm.vb` | 行1654-1670のExecuteメソッド |

**主要処理フロー**:
- **行1655**: If TempProfile.File <> "" Then でファイル存在チェック
- **行1656**: If Not TempProfile.IsInputSupported AndAlso Not TempProfile.DecodingMode = AudioDecodingMode.Pipe Then で条件チェック
- **行1657**: MsgWarn("The input format isn't supported by the current encoder," + BR + "convert to WAV or FLAC first or enable piping in the options.")
- **行1658-1665**: Elseブロックでエンコード処理を実行
- **行1667-1669**: ファイルが空の場合、MsgWarn("Source file is missing!")

#### Step 4: 通知表示の仕組みを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | Msg.vb | `Source/UI/Msg.vb` | MsgWarn関数の実装、TaskDialogを使用した警告通知表示 |

### プログラム呼び出し階層図

```
AudioForm.Execute (行1654)
    │
    ├─ If TempProfile.File <> "" (行1655)
    │      │
    │      ├─ If Not TempProfile.IsInputSupported AndAlso Not DecodingMode = Pipe (行1656)
    │      │      │
    │      │      └─ MsgWarn("The input format isn't supported...") (行1657)
    │      │
    │      └─ Else (行1658)
    │             └─ [エンコード処理実行] (行1659-1665)
    │
    └─ Else (行1667)
           └─ MsgWarn("Source file is missing!") (行1668)
```

### データフロー図

```
[入力]                         [処理]                              [出力]

TempProfile.File ──────────▶ 空チェック ─────────────▶ ソースファイル不在警告（空の場合）
                                   │
TempProfile.IsInputSupported ▶ サポートチェック
                                   │
TempProfile.DecodingMode ────▶ パイプモードチェック
                                   │
                                   ├──▶ サポートまたはパイプ: エンコード処理実行
                                   │
                                   └──▶ 非サポートかつ非パイプ: 入力形式非対応警告
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| AudioForm.vb | `Source/Forms/AudioForm.vb` | ソース | オーディオ設定画面、Executeメソッド |
| AudioProfile.vb | `Source/Audio/AudioProfile.vb` | ソース | オーディオプロファイルクラス |
| AudioDecodingMode.vb | `Source/Audio/AudioDecodingMode.vb` | ソース | デコードモード列挙型 |
| Msg.vb | `Source/UI/Msg.vb` | ソース | MsgWarn等の通知表示関数 |
