# 通知設計書 91-ソースファイル不在警告

## 概要

本ドキュメントは、StaxRipアプリケーションにおけるソースファイル不在警告（Source file is missing!）通知の設計仕様を定義する。この通知はAudioForm画面でオーディオエンコード実行時にソースファイルが設定されていない場合に表示される警告ダイアログである。

### 本通知の処理概要

本通知は、ユーザーがAudioForm画面でオーディオエンコードコマンドを実行しようとした際に、ソースファイルが設定されていない状態を検出して警告を表示する機能を提供する。

**業務上の目的・背景**：オーディオエンコード処理はソースファイルを必須入力として要求する。ソースファイルが設定されていない状態でエンコードを試みると処理が失敗するため、事前にユーザーに警告を表示して操作ミスを防止する。この通知により、ユーザーは実行前にソースファイルを設定する必要があることを認識できる。

**通知の送信タイミング**：AudioForm画面でExecuteメソッドが呼び出された際に、TempProfile.Fileプロパティが空文字列であることを検出したタイミングで表示される。具体的には、ユーザーがオーディオエンコードの実行ボタンをクリックしたときに発生する。

**通知の受信者**：StaxRipアプリケーションを操作しているユーザーがダイアログを通じて直接受信する。GUI上のモーダルダイアログとして表示される。

**通知内容の概要**：「Source file is missing!」という警告メッセージが、警告アイコンとともにタスクダイアログで表示される。ユーザーにソースファイルが設定されていないことを明確に伝える。

**期待されるアクション**：ユーザーはOKボタンをクリックしてダイアログを閉じ、AudioForm画面でソースファイルを設定してから再度エンコード実行を試みることが期待される。

## 通知種別

アプリ内通知（Windowsタスクダイアログ）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（ユーザー応答待ち） |
| 優先度 | 高 |
| リトライ | 無 |

### 送信先決定ロジック

現在AudioForm画面を操作中のユーザーに対してモーダルダイアログとして直接表示される。送信先の決定ロジックは存在せず、操作を行ったユーザーが必ず受信者となる。

## 通知テンプレート

### ダイアログ表示の場合

| 項目 | 内容 |
|-----|------|
| アイコン | TaskIcon.Warning（警告アイコン） |
| タイトル | Source file is missing! |
| ボタン | OK |

### 本文テンプレート

```
Source file is missing!
```

### 添付ファイル

該当なし

## テンプレート変数

該当なし（固定メッセージ）

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 画面操作 | Executeメソッド実行 | TempProfile.File = "" | オーディオエンコード実行時にソースファイルが未設定 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| TempProfile.File <> "" | ソースファイルが設定されている場合は表示されない |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[Execute実行] --> B{TempProfile.File = ""?}
    B -->|Yes| C[MsgWarn表示]
    B -->|No| D{入力形式対応確認}
    C --> E[ユーザー確認待ち]
    E --> F[終了]
    D -->|対応| G[エンコード処理実行]
    D -->|非対応| H[入力形式非対応警告表示]
    G --> F
    H --> F
```

## データベース参照・更新仕様

### 参照テーブル一覧

該当なし（データベースは使用しない）

### 更新テーブル一覧

該当なし

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| ソースファイル未設定 | TempProfile.Fileが空 | 警告表示後、処理を中断 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |
| リトライ間隔 | - |
| リトライ対象エラー | - |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし（ユーザー操作に応じて即時表示）

## セキュリティ考慮事項

本通知は固定のエラーメッセージのみを表示するため、個人情報やセンシティブな情報は含まれない。追加のセキュリティ対策は不要。

## 備考

- 本通知はAudioFormクラスのExecuteメソッド内で発生する
- 入力形式非対応エラー（No.90）とは相互排他的な関係にある

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、オーディオプロファイルのデータ構造を理解することが重要である。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | AudioProfile.vb | `Source/Encoding/Audio/AudioProfile.vb` | Fileプロパティの定義とオーディオプロファイルの構造 |

**読解のコツ**: VB.NETのプロパティ構文に注意。TempProfileはAudioProfileを継承したGUIAudioProfileの一時インスタンスである。

#### Step 2: エントリーポイントを理解する

処理の起点となるファイル・関数を特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | AudioForm.vb | `Source/Forms/AudioForm.vb` | Executeメソッドがエントリーポイント |

**主要処理フロー**:
1. **行1654**: Executeメソッド開始
2. **行1655**: TempProfile.Fileが空でないかチェック
3. **行1667-1668**: ソースファイル未設定時の警告表示処理

#### Step 3: 共通ダイアログ関数を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | General.vb | `Source/General/General.vb` | MsgWarn関数の実装（行1245-1255） |

**主要処理フロー**:
- **行1245**: MsgWarnメソッド定義
- **行1250**: Msg関数呼び出しでTaskDialogを表示

### プログラム呼び出し階層図

```
AudioForm.Execute()
    │
    └─ TempProfile.File判定
           │
           └─ MsgWarn("Source file is missing!")
                  │
                  └─ General.Msg()
                         │
                         └─ TaskDialog.Show()
```

### データフロー図

```
[入力]               [処理]                    [出力]

ユーザー操作 ───▶ Execute() ───▶ モーダルダイアログ表示
(実行ボタン)        │
                   ▼
               TempProfile.File ───▶ 判定結果 ───▶ 警告表示
               (プロパティ参照)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| AudioForm.vb | `Source/Forms/AudioForm.vb` | ソース | 通知発生元のフォームクラス |
| General.vb | `Source/General/General.vb` | ソース | 共通ダイアログ関数の定義 |
| TaskDialog.vb | `Source/UI/TaskDialog.vb` | ソース | タスクダイアログの実装 |
| AudioProfile.vb | `Source/Encoding/Audio/AudioProfile.vb` | ソース | オーディオプロファイルのデータ構造 |
