# 通知設計書 92-削除確認

## 概要

本ドキュメントは、StaxRipアプリケーションにおける削除確認（Remove Selection?）通知の設計仕様を定義する。この通知はListViewEx共通コントロールで選択項目を削除する際に表示される確認ダイアログである。

### 本通知の処理概要

本通知は、ユーザーがListViewEx（拡張リストビュー）コントロールで選択した項目を削除しようとした際に、削除対象の一覧を表示して確認を求める機能を提供する。

**業務上の目的・背景**：リスト形式のデータを管理するUI部品において、誤操作による項目削除を防止するため、削除前にユーザーへ確認を求める。これにより、重要なジョブやプロファイルなどの設定が誤って削除されることを防ぐ。複数箇所で再利用される共通コントロールのため、アプリケーション全体で一貫した削除確認体験を提供する。

**通知の送信タイミング**：ListViewExコントロールのRemoveSelectionメソッドが呼び出され、選択項目が1つ以上存在する場合に表示される。JobsForm、ProfilesFormなど複数の画面でこのコントロールが使用される。

**通知の受信者**：StaxRipアプリケーションを操作しているユーザーがダイアログを通じて直接受信する。GUI上のモーダルダイアログとして表示される。

**通知内容の概要**：「Remove Selection?」というタイトルと、削除対象項目の名前一覧（最大15件、それ以上は省略）がタスクダイアログで表示される。ユーザーは削除を続行するか、キャンセルするかを選択できる。

**期待されるアクション**：ユーザーはOKボタンで削除を続行するか、Cancelボタンで削除をキャンセルする。削除を続行した場合、選択された項目がリストから削除される。

## 通知種別

アプリ内通知（Windowsタスクダイアログ）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（ユーザー応答待ち） |
| 優先度 | 高 |
| リトライ | 無 |

### 送信先決定ロジック

現在ListViewExコントロールを含む画面を操作中のユーザーに対してモーダルダイアログとして直接表示される。

## 通知テンプレート

### ダイアログ表示の場合

| 項目 | 内容 |
|-----|------|
| アイコン | TaskIcon.Question（質問アイコン） |
| タイトル | Remove Selection? |
| ボタン | OK / Cancel |

### 本文テンプレート

```
{選択項目名1}
{選択項目名2}
{選択項目名3}
...
(15件を超える場合)
... and more ...
```

### 添付ファイル

該当なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| names | 選択項目の名前一覧（改行区切り） | SelectedItems.Text または Tag | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 画面操作 | RemoveSelection呼び出し | SelectedItems.Count > 0 | 選択項目が存在する場合に表示 |
| 画面操作 | Deleteキー押下 | SelectedItems.Count > 0 | キーボードショートカットでも同様 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| SelectedItems.Count = 0 | 選択項目がない場合は表示されない |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[RemoveSelection呼び出し] --> B{SelectedItems.Count > 0?}
    B -->|No| C[処理終了]
    B -->|Yes| D[選択項目名を収集]
    D --> E[MsgQuestion表示]
    E --> F{ユーザー選択}
    F -->|OK| G[選択項目を削除]
    F -->|Cancel| C
    G --> H[ItemRemovedイベント発火]
    H --> I[UpdateControls]
    I --> C
```

## データベース参照・更新仕様

### 参照テーブル一覧

該当なし（データベースは使用しない）

### 更新テーブル一覧

該当なし

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| 項目名取得失敗 | Textプロパティが空の場合 | Tagプロパティから取得を試行 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |
| リトライ間隔 | - |
| リトライ対象エラー | - |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし（ユーザー操作に応じて即時表示）

## セキュリティ考慮事項

本通知はユーザーが選択した項目の名前のみを表示する。項目名に機密情報が含まれる可能性があるが、ローカルアプリケーション内での表示に限定されるため、セキュリティリスクは低い。

## 備考

- 本通知はListViewExクラスの共通機能として実装されている
- JobsForm、ProfilesFormなど複数の画面で使用される
- 最大15件の項目名を表示し、それ以上は「... and more ...」で省略

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、ListViewExコントロールの構造を理解することが重要である。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | ListViewEx.vb | `Source/UI/Controls/ListViewEx.vb` | ListViewを継承した拡張リストビューの構造 |

**読解のコツ**: VB.NETのListViewコントロールの継承クラスであり、SelectedItemsプロパティで選択項目にアクセスできる。

#### Step 2: エントリーポイントを理解する

処理の起点となるファイル・関数を特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | ListViewEx.vb | `Source/UI/Controls/ListViewEx.vb` | RemoveSelectionメソッドがエントリーポイント |

**主要処理フロー**:
1. **行436**: RemoveSelectionメソッド開始
2. **行437**: SelectedItems.Count > 0のチェック
3. **行438-449**: 選択項目名の収集（最大15件）
4. **行452**: MsgQuestionダイアログ表示
5. **行456-493**: 削除処理の実行

#### Step 3: 共通ダイアログ関数を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | General.vb | `Source/General/General.vb` | MsgQuestion関数の実装（行1261-1272） |

**主要処理フロー**:
- **行1268**: MsgQuestionオーバーロード（タイトルと内容を受け取る）
- **行1271**: Msg関数呼び出しでTaskDialogを表示

### プログラム呼び出し階層図

```
ListViewEx.RemoveSelection()
    │
    ├─ SelectedItems.Count判定
    │
    ├─ 項目名収集（最大15件）
    │      └─ SelectedItems.OfType(Of ListViewItem)
    │
    └─ MsgQuestion("Remove Selection?", names)
           │
           └─ General.Msg()
                  │
                  └─ TaskDialog.Show()
```

### データフロー図

```
[入力]               [処理]                    [出力]

ユーザー操作 ───▶ RemoveSelection() ───▶ モーダルダイアログ表示
(削除ボタン/
 Deleteキー)        │
                   ▼
               SelectedItems ───▶ 項目名収集 ───▶ 確認ダイアログ
                                      │
                                      ▼
                                 ユーザー選択 ───▶ 削除実行/キャンセル
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| ListViewEx.vb | `Source/UI/Controls/ListViewEx.vb` | ソース | 通知発生元の共通コントロール |
| General.vb | `Source/General/General.vb` | ソース | 共通ダイアログ関数の定義 |
| TaskDialog.vb | `Source/UI/TaskDialog.vb` | ソース | タスクダイアログの実装 |
| JobsForm.vb | `Source/Forms/JobsForm.vb` | ソース | ListViewExを使用するジョブ管理画面 |
| ProfilesForm.vb | `Source/Forms/ProfilesForm.vb` | ソース | ListViewExを使用するプロファイル管理画面 |
