# 通知設計書 93-サブフォルダ含有確認

## 概要

本ドキュメントは、StaxRipアプリケーションにおけるサブフォルダ含有確認（Include sub folders?）通知の設計仕様を定義する。この通知はSourceFilesForm画面でフォルダを追加する際に、サブフォルダ内のファイルも含めるかを確認するダイアログである。

### 本通知の処理概要

本通知は、ユーザーがSourceFilesForm画面でフォルダを追加した際に、選択したフォルダにサブフォルダが存在する場合、サブフォルダ内のビデオファイルも検索対象に含めるかどうかを確認する機能を提供する。

**業務上の目的・背景**：ビデオファイルのバッチ処理では、ソースファイルを複数選択することが多い。フォルダを指定して一括追加する際に、サブフォルダの扱いをユーザーが明示的に選択できるようにすることで、意図しないファイルの追加を防止し、必要なファイルのみを効率的に追加できるようにする。

**通知の送信タイミング**：SourceFilesForm画面の「Add folder」操作でフォルダを選択した後、そのフォルダにサブディレクトリが1つ以上存在する場合に表示される。サブフォルダが存在しない場合は表示されない。

**通知の受信者**：StaxRipアプリケーションを操作しているユーザーがダイアログを通じて直接受信する。GUI上のモーダルダイアログとして表示される。

**通知内容の概要**：「Include sub folders?」という質問がタスクダイアログで表示される。ユーザーはYesでサブフォルダを含める、Noでサブフォルダを除外するかを選択できる。

**期待されるアクション**：ユーザーはYesボタンでサブフォルダを含めた再帰的検索を行うか、Noボタンで選択フォルダ直下のみの検索を行う。選択結果に基づいてビデオファイルがリストに追加される。

## 通知種別

アプリ内通知（Windowsタスクダイアログ）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（ユーザー応答待ち） |
| 優先度 | 中 |
| リトライ | 無 |

### 送信先決定ロジック

現在SourceFilesForm画面を操作中のユーザーに対してモーダルダイアログとして直接表示される。

## 通知テンプレート

### ダイアログ表示の場合

| 項目 | 内容 |
|-----|------|
| アイコン | TaskIcon.Question（質問アイコン） |
| タイトル | Include sub folders? |
| ボタン | Yes / No |

### 本文テンプレート

```
Include sub folders?
```

### 添付ファイル

該当なし

## テンプレート変数

該当なし（固定メッセージ）

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 画面操作 | フォルダ追加ダイアログOK | subfolders.Count > 0 | 選択フォルダにサブフォルダが存在する場合 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| subfolders.Count = 0 | サブフォルダが存在しない場合は表示されない |
| IsMerge = True | マージモードの場合はフォルダ追加オプションが表示されない |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[Add folder選択] --> B[FolderBrowserDialog表示]
    B --> C{ダイアログ結果}
    C -->|Cancel| D[処理終了]
    C -->|OK| E[サブフォルダ取得]
    E --> F{subfolders.Count > 0?}
    F -->|No| G[TopDirectoryOnlyで検索]
    F -->|Yes| H[MsgQuestion表示]
    H --> I{ユーザー選択}
    I -->|Yes| J[AllDirectoriesで検索]
    I -->|No| G
    G --> K[ビデオファイルをリストに追加]
    J --> K
    K --> D
```

## データベース参照・更新仕様

### 参照テーブル一覧

該当なし（データベースは使用しない）

### 更新テーブル一覧

該当なし

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| ファイルシステムアクセスエラー | フォルダへのアクセス権限がない場合 | 例外発生、該当フォルダをスキップ |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |
| リトライ間隔 | - |
| リトライ対象エラー | - |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし（ユーザー操作に応じて即時表示）

## セキュリティ考慮事項

本通知は固定のメッセージのみを表示し、ファイルパスなどの情報は含まれない。セキュリティリスクは低い。ただし、サブフォルダの再帰的検索はシステムリソースを消費する可能性があるため、大量のサブフォルダが存在する場合は処理時間が長くなる可能性がある。

## 備考

- 本通知はSourceFilesFormクラスのbnAdd_Clickメソッド内で発生する
- 検索対象はFileTypes.Videoに含まれる拡張子のファイルのみ
- 結果はStringLogicalComparerでソートされてリストに追加される

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、ファイルタイプの定義とSearchOptionの選択肢を理解することが重要である。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | FileTypes.vb | `Source/General/FileTypes.vb` | Video拡張子の定義 |

**読解のコツ**: SearchOptionはSystem.IO名前空間のEnum型で、TopDirectoryOnlyとAllDirectoriesの2値を持つ。

#### Step 2: エントリーポイントを理解する

処理の起点となるファイル・関数を特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | SourceFilesForm.vb | `Source/Forms/SourceFilesForm.vb` | bnAdd_Clickメソッドがエントリーポイント |

**主要処理フロー**:
1. **行230**: bnAdd_Clickメソッド開始
2. **行236-260**: TaskDialogでファイル/フォルダ追加の選択
3. **行244-258**: フォルダ追加処理
4. **行246**: サブフォルダの取得
5. **行249-252**: サブフォルダ存在時の確認ダイアログ
6. **行255**: ビデオファイルの検索とリスト追加

#### Step 3: 共通ダイアログ関数を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | General.vb | `Source/General/General.vb` | MsgQuestion関数の実装（行1261-1272） |

**主要処理フロー**:
- **行1261**: MsgQuestion関数でTaskButton.YesNoを使用

### プログラム呼び出し階層図

```
SourceFilesForm.bnAdd_Click()
    │
    ├─ TaskDialog("Add files" / "Add folder")
    │
    └─ "Add folder"選択時
           │
           ├─ FolderBrowserDialog.ShowDialog()
           │
           ├─ Directory.GetDirectories()
           │      └─ サブフォルダ一覧取得
           │
           ├─ MsgQuestion("Include sub folders?", TaskButton.YesNo)
           │      │
           │      └─ General.Msg() → TaskDialog.Show()
           │
           └─ Directory.GetFiles()
                  └─ ビデオファイル検索
```

### データフロー図

```
[入力]               [処理]                    [出力]

フォルダ選択 ───▶ GetDirectories() ───▶ サブフォルダ一覧
                       │
                       ▼
               サブフォルダ数判定 ───▶ 確認ダイアログ表示
                       │
                       ▼
               ユーザー選択 ───▶ SearchOption決定
                       │
                       ▼
               GetFiles() ───▶ ビデオファイル一覧 ───▶ リストに追加
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| SourceFilesForm.vb | `Source/Forms/SourceFilesForm.vb` | ソース | 通知発生元のフォームクラス |
| General.vb | `Source/General/General.vb` | ソース | 共通ダイアログ関数の定義 |
| TaskDialog.vb | `Source/UI/TaskDialog.vb` | ソース | タスクダイアログの実装 |
| FileTypes.vb | `Source/General/FileTypes.vb` | ソース | ファイル拡張子の定義 |
| StringLogicalComparer.vb | `Source/General/StringLogicalComparer.vb` | ソース | 自然順ソートの実装 |
