# 通知設計書 94-ファイル削除警告

## 概要

本ドキュメントは、StaxRipアプリケーションにおけるファイル削除警告（file type will be deleted）通知の設計仕様を定義する。この通知はMainForm_ShowOptions画面で一時ファイル削除設定を「除外モード」に変更した際に表示される警告ダイアログである。

### 本通知の処理概要

本通知は、ユーザーがオプション設定画面で一時ファイル削除の選択モードを「Exclude（除外）」に変更した際に、選択されていないファイルタイプが削除対象になることを警告する機能を提供する。

**業務上の目的・背景**：StaxRipはエンコード処理後に一時ファイルを削除する機能を持つ。選択モードが「Exclude」の場合、明示的に選択されていないファイルタイプがすべて削除対象となる。これは意図しないファイル削除につながる可能性があるため、設定変更時にユーザーへ警告を表示して、データ損失リスクを認識させる必要がある。

**通知の送信タイミング**：オプション設定画面（MainForm_ShowOptions）で、DeleteTempFilesSelectionModeの値がSelectionMode.Excludeに変更された瞬間に表示される。ValueChangedActionコールバック内で発火する。

**通知の受信者**：StaxRipアプリケーションを操作しているユーザーがダイアログを通じて直接受信する。GUI上のモーダルダイアログとして表示される。

**通知内容の概要**：「Be aware!」というタイトルと「Every not selected, listed or identified file type will be deleted!」という本文で、除外モードの動作を警告する。

**期待されるアクション**：ユーザーはOKボタンをクリックして警告を確認し、除外モードの動作を理解した上で設定を続行する。必要に応じて、選択モードを「Include」に戻すか、削除対象外とするファイルタイプを明示的に選択する。

## 通知種別

アプリ内通知（Windowsタスクダイアログ）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（ユーザー応答待ち） |
| 優先度 | 高 |
| リトライ | 無 |

### 送信先決定ロジック

現在オプション設定画面を操作中のユーザーに対してモーダルダイアログとして直接表示される。

## 通知テンプレート

### ダイアログ表示の場合

| 項目 | 内容 |
|-----|------|
| アイコン | TaskIcon.Warning（警告アイコン） |
| タイトル | Be aware! |
| ボタン | OK |

### 本文テンプレート

```
Every not selected, listed or identified file type will be deleted!
```

### 添付ファイル

該当なし

## テンプレート変数

該当なし（固定メッセージ）

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 画面操作 | SelectionMode変更 | value = SelectionMode.Exclude | 選択モードが除外に変更された場合 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| value = SelectionMode.Include | 選択モードが含有の場合は表示されない |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[SelectionMode変更] --> B{value = Exclude?}
    B -->|No| C[ラベルテキスト更新のみ]
    B -->|Yes| D[ラベルテキスト更新]
    D --> E[MsgWarn表示]
    E --> F[終了]
    C --> F
```

## データベース参照・更新仕様

### 参照テーブル一覧

該当なし（データベースは使用しない）

### 更新テーブル一覧

該当なし（設定はレジストリまたはファイルに保存）

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| 該当なし | - | - |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |
| リトライ間隔 | - |
| リトライ対象エラー | - |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし（ユーザー操作に応じて即時表示）

## セキュリティ考慮事項

本通知は固定のエラーメッセージのみを表示するため、個人情報やセンシティブな情報は含まれない。ただし、この警告を無視した場合、意図しないファイル削除が発生する可能性があり、データ損失リスクがある。

## 備考

- 本通知はMainForm_ShowOptionsクラスのValueChangedActionコールバック内で発生する
- DeleteTempFilesMode、DeleteTempFilesSelection、DeleteTempFilesSelectionModeの3つの設定項目が関連する
- 「Selective」選択時と「Custom」選択時でこの設定が有効になる

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、削除モードに関する列挙型の定義を理解することが重要である。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Project.vb | `Source/General/Project.vb` | DeleteMode、DeleteSelection、SelectionModeの定義 |

**読解のコツ**: SelectionModeはIncludeとExcludeの2値を持つ。Excludeの場合、選択されていない項目が削除対象となる（否定論理）。

#### Step 2: エントリーポイントを理解する

処理の起点となるファイル・関数を特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | MainForm_ShowOptions.vb | `Source/Forms/MainForm_ShowOptions.vb` | 一時ファイル削除設定セクション |

**主要処理フロー**:
1. **行897**: deleteSelectionModeMenuの設定開始
2. **行901-906**: ValueChangedActionコールバック定義
3. **行902**: ラベルテキストの更新
4. **行903-905**: Excludeモード時の警告表示

#### Step 3: 共通ダイアログ関数を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | General.vb | `Source/General/General.vb` | MsgWarn関数の実装（行1245-1255） |

**主要処理フロー**:
- **行1245**: MsgWarnメソッド定義（タイトルと内容の2引数）
- **行1250**: Msg関数呼び出しでTaskDialogを表示

### プログラム呼び出し階層図

```
MainForm_ShowOptions
    │
    └─ deleteSelectionModeMenu.Button.ValueChangedAction
           │
           ├─ ラベルテキスト更新（Include/Exclude）
           │
           └─ If Exclude Then
                  │
                  └─ MsgWarn("Be aware!", "Every not selected...")
                         │
                         └─ General.Msg()
                                │
                                └─ TaskDialog.Show()
```

### データフロー図

```
[入力]               [処理]                    [出力]

選択モード変更 ───▶ ValueChangedAction ───▶ ラベル更新
(Include/Exclude)        │
                        ▼
                    Exclude判定 ───▶ 警告ダイアログ表示
                        │
                        ▼
                    設定保存 ───▶ p.DeleteTempFilesSelectionMode
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| MainForm_ShowOptions.vb | `Source/Forms/MainForm_ShowOptions.vb` | ソース | 通知発生元のオプション設定画面 |
| General.vb | `Source/General/General.vb` | ソース | 共通ダイアログ関数の定義 |
| TaskDialog.vb | `Source/UI/TaskDialog.vb` | ソース | タスクダイアログの実装 |
| Project.vb | `Source/General/Project.vb` | ソース | プロジェクト設定とEnum定義 |
