# 通知設計書 95-テンプレート復元確認

## 概要

本ドキュメントは、StaxRipアプリケーションにおけるテンプレート復元確認（Restore the default templates?）通知の設計仕様を定義する。この通知はMainForm画面でテンプレートのデフォルト復元操作を行う際に表示される確認ダイアログである。

### 本通知の処理概要

本通知は、ユーザーがメインフォームのテンプレートメニューから「Restore」を選択した際に、デフォルトテンプレートの復元を実行するかどうかを確認する機能を提供する。

**業務上の目的・背景**：StaxRipはプロジェクトテンプレート機能を持ち、ユーザーはカスタマイズしたテンプレートを作成・保存できる。デフォルトテンプレートの復元操作は、カスタマイズしたテンプレートをすべて削除してデフォルト状態に戻す破壊的な操作である。誤操作を防止するため、実行前にユーザーへ確認を求める必要がある。

**通知の送信タイミング**：MainForm画面のテンプレートメニューから「Restore」を選択した際に、ResetTemplatesメソッドが呼び出されて表示される。

**通知の受信者**：StaxRipアプリケーションを操作しているユーザーがダイアログを通じて直接受信する。GUI上のモーダルダイアログとして表示される。

**通知内容の概要**：「Restore the default templates?」という質問がタスクダイアログで表示される。ユーザーはOKで復元を実行、Cancelでキャンセルを選択できる。

**期待されるアクション**：ユーザーはOKボタンで復元を実行するか、Cancelボタンで操作をキャンセルする。OKを選択した場合、テンプレートフォルダが削除され、デフォルトテンプレートが再作成される。

## 通知種別

アプリ内通知（Windowsタスクダイアログ）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（ユーザー応答待ち） |
| 優先度 | 高 |
| リトライ | 無 |

### 送信先決定ロジック

現在MainForm画面を操作中のユーザーに対してモーダルダイアログとして直接表示される。

## 通知テンプレート

### ダイアログ表示の場合

| 項目 | 内容 |
|-----|------|
| アイコン | TaskIcon.Question（質問アイコン） |
| タイトル | Restore the default templates? |
| ボタン | OK / Cancel |

### 本文テンプレート

```
Restore the default templates?
```

### 添付ファイル

該当なし

## テンプレート変数

該当なし（固定メッセージ）

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 画面操作 | Restore選択 | 常に表示 | テンプレートメニューからRestore選択時 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| なし | 常に表示される |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[Restore選択] --> B[ResetTemplates呼び出し]
    B --> C[MsgQuestion表示]
    C --> D{ユーザー選択}
    D -->|OK| E[テンプレートフォルダ削除]
    D -->|Cancel| F[終了]
    E --> G[デフォルトテンプレート再作成]
    G --> H[テンプレートメニュー更新]
    H --> F
```

## データベース参照・更新仕様

### 参照テーブル一覧

該当なし（データベースは使用しない）

### 更新テーブル一覧

該当なし（ファイルシステム上のテンプレートフォルダを操作）

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| フォルダ削除失敗 | ファイルがロックされている等 | 例外をキャッチしてg.ShowExceptionで表示 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |
| リトライ間隔 | - |
| リトライ対象エラー | - |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし（ユーザー操作に応じて即時表示）

## セキュリティ考慮事項

本通知は固定のメッセージのみを表示するため、セキュリティリスクは低い。ただし、復元操作はカスタマイズしたテンプレートをすべて削除するため、データ損失リスクがある。

## 備考

- 本通知はMainFormクラスのResetTemplatesメソッド内で発生する
- 復元処理ではFolderHelp.Deleteでテンプレートフォルダを削除
- Folder.Template.ToString()でデフォルトテンプレートが再作成される
- 復元後、UpdateTemplatesMenuAsyncでメニューが更新される

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、テンプレートフォルダの構造を理解することが重要である。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Folder.vb | `Source/General/Folder.vb` | Folder.Templateプロパティの定義 |

**読解のコツ**: Folder.TemplateはテンプレートフォルダへのパスをSharedプロパティとして提供する。

#### Step 2: エントリーポイントを理解する

処理の起点となるファイル・関数を特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | MainForm.vb | `Source/Forms/MainForm.vb` | ResetTemplatesメソッドがエントリーポイント |

**主要処理フロー**:
1. **行1481**: ResetTemplatesメソッド開始
2. **行1482**: MsgQuestionダイアログ表示
3. **行1483-1489**: 復元処理（Try-Catch）
4. **行1484**: FolderHelp.Deleteでフォルダ削除
5. **行1485**: Folder.Template.ToString()でデフォルト再作成
6. **行1486**: UpdateTemplatesMenuAsync呼び出し

#### Step 3: 共通ダイアログ関数を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | General.vb | `Source/General/General.vb` | MsgQuestion関数の実装（行1261-1266） |

### プログラム呼び出し階層図

```
MainForm.ResetTemplates()
    │
    ├─ MsgQuestion("Restore the default templates?")
    │      │
    │      └─ General.Msg() → TaskDialog.Show()
    │
    └─ DialogResult.OK の場合
           │
           ├─ FolderHelp.Delete(Folder.Template)
           │
           ├─ Folder.Template.ToString()
           │      └─ デフォルトテンプレート再作成
           │
           └─ UpdateTemplatesMenuAsync()
```

### データフロー図

```
[入力]               [処理]                    [出力]

Restore選択 ───▶ MsgQuestion() ───▶ 確認ダイアログ表示
                       │
                       ▼
               ユーザー選択 ───▶ OK/Cancel
                       │
                       ▼ (OK時)
               FolderHelp.Delete() ───▶ テンプレートフォルダ削除
                       │
                       ▼
               Folder.Template ───▶ デフォルト再作成
                       │
                       ▼
               UpdateTemplatesMenuAsync() ───▶ メニュー更新
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| MainForm.vb | `Source/Forms/MainForm.vb` | ソース | 通知発生元のメインフォーム |
| General.vb | `Source/General/General.vb` | ソース | 共通ダイアログ関数の定義 |
| TaskDialog.vb | `Source/UI/TaskDialog.vb` | ソース | タスクダイアログの実装 |
| Folder.vb | `Source/General/Folder.vb` | ソース | フォルダパスの定義 |
| FolderHelp.vb | `Source/General/FolderHelp.vb` | ソース | フォルダ操作ヘルパー |
