# 通知設計書 96-VOB開封確認

## 概要

本ドキュメントは、StaxRipアプリケーションにおけるVOB開封確認（Are you sure you want to open the file）通知の設計仕様を定義する。この通知はMainForm画面でDVDのVOBファイル（特に最初のVOBファイル）を開く際に表示される確認ダイアログである。

### 本通知の処理概要

本通知は、ユーザーがDVDのVOBファイルを開こうとした際に、そのファイルがメニューを含む可能性がある最初のVOBファイル（VTS_0X_0.VOB形式）であることを警告し、開いてよいかを確認する機能を提供する。

**業務上の目的・背景**：DVDのVOBファイル構造では、各タイトルセットの最初のVOBファイル（VTS_XX_0.VOB）にはメニューが含まれていることが多い。メニュー部分は通常エンコード対象ではないため、誤ってメニューVOBを選択してしまうとユーザーの期待と異なる結果になる。この確認ダイアログにより、ユーザーは意図的にそのファイルを選択しているかを再確認できる。

**通知の送信タイミング**：MainForm画面でソースファイルを開く処理中に、ファイル名が「VTS_0X_0.VOB」パターン（Xは1桁の数字）にマッチした場合に表示される。

**通知の受信者**：StaxRipアプリケーションを操作しているユーザーがダイアログを通じて直接受信する。GUI上のモーダルダイアログとして表示される。

**通知内容の概要**：「Are you sure you want to open the file {ファイル名}, the first VOB file usually contains a menu.」という質問がタスクダイアログで表示される。ユーザーはOKで続行、Cancelでキャンセルを選択できる。

**期待されるアクション**：ユーザーはOKボタンでファイルを開く処理を続行するか、Cancelボタンで処理をキャンセルする。キャンセルした場合はAbortExceptionがスローされ、ソースファイル読み込み処理が中断される。

## 通知種別

アプリ内通知（Windowsタスクダイアログ）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（ユーザー応答待ち） |
| 優先度 | 高 |
| リトライ | 無 |

### 送信先決定ロジック

現在MainForm画面を操作中のユーザーに対してモーダルダイアログとして直接表示される。

## 通知テンプレート

### ダイアログ表示の場合

| 項目 | 内容 |
|-----|------|
| アイコン | TaskIcon.Question（質問アイコン） |
| タイトル | Are you sure you want to open the file {ファイル名}, |
| 内容 | the first VOB file usually contains a menu. |
| ボタン | OK / Cancel |

### 本文テンプレート

```
Are you sure you want to open the file {ファイル名},
the first VOB file usually contains a menu.
```

### 添付ファイル

該当なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| name | ファイル名 | i.FileName | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 画面操作 | ソースファイル読み込み | name Like "VTS_0#_0.VOB" | ファイル名が最初のVOBパターンに一致 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| ファイル名が該当パターンに不一致 | VTS_XX_0.VOB以外のファイルでは表示されない |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[ソースファイル読み込み開始] --> B[ファイル一覧ループ]
    B --> C{ファイル名 Like VTS_0#_0.VOB?}
    C -->|No| D{VIDEO_TS.VOB?}
    C -->|Yes| E[MsgQuestion表示]
    E --> F{ユーザー選択}
    F -->|OK| D
    F -->|Cancel| G[AbortException]
    D -->|Yes| H[MsgWarn + AbortException]
    D -->|No| I[ファイル処理続行]
    G --> J[処理中断]
    H --> J
    I --> K[次のファイルへ]
    K --> B
```

## データベース参照・更新仕様

### 参照テーブル一覧

該当なし（データベースは使用しない）

### 更新テーブル一覧

該当なし

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| キャンセル選択 | ユーザーがCancelを選択 | AbortExceptionをスロー |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |
| リトライ間隔 | - |
| リトライ対象エラー | - |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし（ユーザー操作に応じて即時表示）

## セキュリティ考慮事項

本通知はファイル名のみを表示するため、セキュリティリスクは低い。ファイルパスは含まれない。

## 備考

- 本通知はMainFormクラスのソースファイル読み込み処理内で発生する
- Like演算子で「VTS_0#_0.VOB」パターンをチェック（#は任意の1桁数字）
- VIDEO_TS.VOBは別途警告（No.54）で処理される
- DVDのタイトルセット構造を理解した上での実装

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、DVDのVOBファイル構造を理解することが重要である。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | - | - | DVD構造：VTS_XX_Y.VOB（XX=タイトルセット、Y=パート番号、Y=0はメニュー） |

**読解のコツ**: VB.NETのLike演算子は、#が任意の1桁数字にマッチするワイルドカードとして機能する。

#### Step 2: エントリーポイントを理解する

処理の起点となるファイル・関数を特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | MainForm.vb | `Source/Forms/MainForm.vb` | ソースファイル読み込み処理 |

**主要処理フロー**:
1. **行2458**: ファイル一覧のループ開始
2. **行2459**: ファイル名の取得（i.FileName）
3. **行2461**: VTS_0#_0.VOBパターンのチェック
4. **行2462**: MsgQuestionダイアログ表示
5. **行2463**: キャンセル時のAbortExceptionスロー

#### Step 3: 共通ダイアログ関数を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | General.vb | `Source/General/General.vb` | MsgQuestion関数の実装（行1268-1272） |

### プログラム呼び出し階層図

```
MainForm (ソースファイル読み込み)
    │
    └─ For Each i In files
           │
           ├─ name.ToUpperInvariant Like "VTS_0#_0.VOB"
           │      │
           │      └─ MsgQuestion("Are you sure...", "...contains a menu.")
           │             │
           │             └─ Cancel → Throw New AbortException
           │
           └─ name.ToUpperInvariant = "VIDEO_TS.VOB"
                  │
                  └─ MsgWarn + AbortException
```

### データフロー図

```
[入力]               [処理]                    [出力]

ソースファイル ───▶ ファイル名チェック ───▶ パターン判定
                       │
                       ▼
               VTS_0#_0.VOB? ───▶ 確認ダイアログ表示
                       │
                       ▼
               ユーザー選択 ───▶ OK/Cancel
                       │
                       ▼ (Cancel時)
               AbortException ───▶ 処理中断
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| MainForm.vb | `Source/Forms/MainForm.vb` | ソース | 通知発生元のメインフォーム |
| General.vb | `Source/General/General.vb` | ソース | 共通ダイアログ関数の定義 |
| TaskDialog.vb | `Source/UI/TaskDialog.vb` | ソース | タスクダイアログの実装 |
| AbortException.vb | `Source/General/AbortException.vb` | ソース | 処理中断用例外クラス |
