# 通知設計書 97-ジョブ上書き確認

## 概要

本ドキュメントは、StaxRipアプリケーションにおけるジョブ上書き確認（active job for this project already exists）通知の設計仕様を定義する。この通知はMainForm画面でジョブを追加する際に、同じプロジェクトに対するアクティブなジョブが既に存在する場合に表示される確認ダイアログである。

### 本通知の処理概要

本通知は、ユーザーがエンコードジョブをキューに追加しようとした際に、現在のプロジェクトに対するアクティブなジョブが既に存在する場合、そのジョブを上書きするかどうかを確認する機能を提供する。

**業務上の目的・背景**：StaxRipはジョブキュー機能を持ち、複数のエンコードジョブを順番に処理できる。同一プロジェクトに対して複数のジョブを追加すると、ジョブの重複や競合が発生する可能性がある。既存のアクティブジョブを上書きするかどうかをユーザーに確認することで、意図しないジョブの重複を防止する。

**通知の送信タイミング**：MainForm画面でジョブ追加処理（AddJobInternal等）が実行される際に、JobManager.GetJobs()から取得したジョブ一覧に、現在のプロジェクトパスと一致するアクティブなジョブが存在する場合に表示される。

**通知の受信者**：StaxRipアプリケーションを操作しているユーザーがダイアログを通じて直接受信する。GUI上のモーダルダイアログとして表示される。

**通知内容の概要**：「An active job for this project already exists. If you continue, it will be overwritten.」というメッセージがタスクダイアログで表示される。ユーザーはOKで上書きを続行、Cancelでキャンセルを選択できる。

**期待されるアクション**：ユーザーはOKボタンで既存ジョブを上書きしてジョブを追加するか、Cancelボタンでジョブ追加をキャンセルする。

## 通知種別

アプリ内通知（Windowsタスクダイアログ）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（ユーザー応答待ち） |
| 優先度 | 高 |
| リトライ | 無 |

### 送信先決定ロジック

現在MainForm画面を操作中のユーザーに対してモーダルダイアログとして直接表示される。

## 通知テンプレート

### ダイアログ表示の場合

| 項目 | 内容 |
|-----|------|
| アイコン | TaskIcon.Question（質問アイコン） |
| タイトル | An active job for this project already exists. |
| 内容 | If you continue, it will be overwritten. |
| ボタン | OK / Cancel |

### 本文テンプレート

```
An active job for this project already exists.
If you continue, it will be overwritten.
```

### 添付ファイル

該当なし

## テンプレート変数

該当なし（固定メッセージ）

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 画面操作 | ジョブ追加 | jobs.Any() = True | 同一プロジェクトのアクティブジョブが存在 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| jobs.Any() = False | 同一プロジェクトのアクティブジョブが存在しない場合 |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[ジョブ追加開始] --> B[AssistantPassed確認]
    B -->|False| C[処理終了]
    B -->|True| D[ディスク容量確認]
    D -->|不足| C
    D -->|OK| E[JobManager.GetJobs取得]
    E --> F[同一プロジェクトのアクティブジョブ抽出]
    F --> G{jobs.Any()?}
    G -->|No| H[ジョブ追加処理続行]
    G -->|Yes| I[MsgQuestion表示]
    I --> J{ユーザー選択}
    J -->|OK| H
    J -->|Cancel| C
    H --> K[ジョブ保存]
```

## データベース参照・更新仕様

### 参照テーブル一覧

該当なし（ファイルベースのジョブ管理）

### 更新テーブル一覧

該当なし

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| キャンセル選択 | ユーザーがCancelを選択 | ジョブ追加処理を中断 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |
| リトライ間隔 | - |
| リトライ対象エラー | - |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし（ユーザー操作に応じて即時表示）

## セキュリティ考慮事項

本通知は固定のメッセージのみを表示し、プロジェクトパスなどの情報は含まれない。セキュリティリスクは低い。

## 備考

- 本通知はMainFormクラスのジョブ追加処理内で発生する
- JobManager.GetJobs()でジョブ一覧を取得
- jobs.Where(Function(x) x.Active AndAlso x.Path = jobPath)でフィルタリング
- BR定数（改行）を使用してタイトルと本文を連結

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、ジョブ管理の構造を理解することが重要である。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | JobManager.vb | `Source/General/JobManager.vb` | ジョブ管理クラスの構造 |
| 1-2 | Job.vb | `Source/General/Job.vb` | ジョブクラスのActiveプロパティとPathプロパティ |

**読解のコツ**: JobManagerはジョブファイル（.job）を管理し、GetJobs()でファイルからジョブ一覧を読み込む。

#### Step 2: エントリーポイントを理解する

処理の起点となるファイル・関数を特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | MainForm.vb | `Source/Forms/MainForm.vb` | ジョブ追加処理 |

**主要処理フロー**:
1. **行4105**: RaiseAppEvent(ApplicationEvent.BeforeJobAdding)
2. **行4107**: jobPath取得（JobManager.JobPath）
3. **行4108**: ジョブ一覧取得とフィルタリング
4. **行4110**: jobs.Any()で存在確認
5. **行4111**: MsgQuestionダイアログ表示
6. **行4112**: キャンセル時のExit Sub

#### Step 3: 共通ダイアログ関数を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | General.vb | `Source/General/General.vb` | MsgQuestion関数の実装（行1268-1272） |

### プログラム呼び出し階層図

```
MainForm (ジョブ追加処理)
    │
    ├─ g.RaiseAppEvent(BeforeJobAdding)
    │
    ├─ JobManager.JobPath
    │
    ├─ JobManager.GetJobs()
    │      └─ Where(x => x.Active AndAlso x.Path = jobPath)
    │
    └─ If jobs.Any() Then
           │
           └─ MsgQuestion("An active job...", TaskButton.OkCancel)
                  │
                  ├─ OK → ジョブ追加続行
                  │
                  └─ Cancel → Exit Sub
```

### データフロー図

```
[入力]               [処理]                    [出力]

ジョブ追加操作 ───▶ JobManager.GetJobs() ───▶ ジョブ一覧
                       │
                       ▼
               フィルタリング ───▶ 同一プロジェクトのアクティブジョブ
               (Active & Path)      │
                       ▼
               Any()判定 ───▶ 確認ダイアログ表示
                       │
                       ▼
               ユーザー選択 ───▶ OK/Cancel
                       │
                       ▼ (OK時)
               ジョブ追加 ───▶ ジョブファイル保存
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| MainForm.vb | `Source/Forms/MainForm.vb` | ソース | 通知発生元のメインフォーム |
| General.vb | `Source/General/General.vb` | ソース | 共通ダイアログ関数の定義 |
| TaskDialog.vb | `Source/UI/TaskDialog.vb` | ソース | タスクダイアログの実装 |
| JobManager.vb | `Source/General/JobManager.vb` | ソース | ジョブ管理クラス |
| Job.vb | `Source/General/Job.vb` | ソース | ジョブデータクラス |
