# 通知設計書 98-処理中断確認

## 概要

本ドキュメントは、StaxRipアプリケーションにおける処理中断確認（Abort processing?）通知の設計仕様を定義する。この通知はProcessingForm画面でエンコード処理を中断する際に表示される確認ダイアログである。

### 本通知の処理概要

本通知は、ユーザーがProcessingForm画面で現在実行中のエンコード処理を中断しようとした際に、本当に中断してよいかを確認する機能を提供する。

**業務上の目的・背景**：エンコード処理は長時間を要することが多く、処理中断は進行中の作業を失うことを意味する。誤操作による中断を防止し、ユーザーが意図的に中断を選択していることを確認するため、中断前に確認ダイアログを表示する必要がある。中断後は処理を再開することができないため、慎重な操作が求められる。

**通知の送信タイミング**：ProcessingForm画面でAbortメソッドが呼び出された際に表示される。これはユーザーが中断ボタンをクリックしたときに発生する。

**通知の受信者**：StaxRipアプリケーションを操作しているユーザーがダイアログを通じて直接受信する。GUI上のモーダルダイアログとして表示される。

**通知内容の概要**：「Abort processing?」という質問がタスクダイアログで表示される。ユーザーはOKで中断を実行、Cancelでキャンセルを選択できる。

**期待されるアクション**：ユーザーはOKボタンで処理を中断するか、Cancelボタンで中断をキャンセルして処理を続行する。中断を選択した場合、ログが保存され、ProcControllerのAbortメソッドが呼び出される。

## 通知種別

アプリ内通知（Windowsタスクダイアログ）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（ユーザー応答待ち） |
| 優先度 | 高 |
| リトライ | 無 |

### 送信先決定ロジック

現在ProcessingForm画面を操作中のユーザーに対してモーダルダイアログとして直接表示される。

## 通知テンプレート

### ダイアログ表示の場合

| 項目 | 内容 |
|-----|------|
| アイコン | TaskIcon.Question（質問アイコン） |
| タイトル | Abort processing? |
| ボタン | OK / Cancel |

### 本文テンプレート

```
Abort processing?
```

### 添付ファイル

該当なし

## テンプレート変数

該当なし（固定メッセージ）

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 画面操作 | 中断ボタンクリック | 常に表示 | Abortメソッド呼び出し時 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| なし | 常に表示される |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[中断ボタンクリック] --> B[Abortメソッド呼び出し]
    B --> C[MsgOK表示]
    C --> D{ユーザー選択}
    D -->|True/OK| E[Log.Save]
    D -->|False/Cancel| F[処理続行]
    E --> G[ProcController.SetLastActivation]
    G --> H[ProcController.Abort]
    H --> I[処理中断]
    F --> J[終了]
    I --> J
```

## データベース参照・更新仕様

### 参照テーブル一覧

該当なし（データベースは使用しない）

### 更新テーブル一覧

該当なし

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| ログ保存失敗 | ファイルアクセスエラー | 例外処理（詳細は別途） |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |
| リトライ間隔 | - |
| リトライ対象エラー | - |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし（ユーザー操作に応じて即時表示）

## セキュリティ考慮事項

本通知は固定のメッセージのみを表示するため、セキュリティリスクは低い。ただし、中断操作は進行中の処理を強制終了するため、不完全な出力ファイルが残る可能性がある。

## 備考

- 本通知はProcessingFormクラスのAbortメソッド内で発生する
- MsgOK関数はBoolean戻り値を返し、Trueで中断を実行
- 中断前にLog.Save()でログを保存
- ProcController.SetLastActivation()でアクティベーション状態を更新
- プロセススキップ確認（No.99）とは別のメソッド

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、処理コントローラの構造を理解することが重要である。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | ProcController.vb | `Source/General/ProcController.vb` | 処理コントローラの構造とAbortメソッド |

**読解のコツ**: ProcControllerは外部プロセスの実行を制御し、Abortメソッドで実行中のプロセスを強制終了する。

#### Step 2: エントリーポイントを理解する

処理の起点となるファイル・関数を特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | ProcessingForm.vb | `Source/Forms/ProcessingForm.vb` | Abortメソッドがエントリーポイント |

**主要処理フロー**:
1. **行360**: Abortメソッド開始
2. **行361**: MsgOKダイアログ表示
3. **行362**: Log.Save()でログ保存
4. **行363**: ProcController.SetLastActivation()
5. **行364**: ProcController.Abort()で処理中断

#### Step 3: 共通ダイアログ関数を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | General.vb | `Source/General/General.vb` | MsgOK関数の実装（行1257-1259） |

**主要処理フロー**:
- **行1257**: MsgOK関数定義（Boolean戻り値）
- **行1258**: Msg関数呼び出しでTaskDialogを表示

### プログラム呼び出し階層図

```
ProcessingForm.Abort()
    │
    └─ MsgOK("Abort processing?")
           │
           └─ General.Msg() → TaskDialog.Show()
                  │
                  └─ True (OK選択時)
                         │
                         ├─ Log.Save()
                         │
                         ├─ ProcController.SetLastActivation()
                         │
                         └─ ProcController.Abort()
```

### データフロー図

```
[入力]               [処理]                    [出力]

中断ボタン ───▶ MsgOK() ───▶ 確認ダイアログ表示
                       │
                       ▼
               ユーザー選択 ───▶ True/False
                       │
                       ▼ (True時)
               Log.Save() ───▶ ログファイル出力
                       │
                       ▼
               ProcController.Abort() ───▶ プロセス強制終了
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| ProcessingForm.vb | `Source/Forms/ProcessingForm.vb` | ソース | 通知発生元の処理画面 |
| General.vb | `Source/General/General.vb` | ソース | 共通ダイアログ関数の定義 |
| TaskDialog.vb | `Source/UI/TaskDialog.vb` | ソース | タスクダイアログの実装 |
| ProcController.vb | `Source/General/ProcController.vb` | ソース | プロセス制御クラス |
| Log.vb | `Source/General/Log.vb` | ソース | ログ管理クラス |
