# 通知設計書 99-プロセススキップ確認

## 概要

本ドキュメントは、StaxRipアプリケーションにおけるプロセススキップ確認（Skip current process?）通知の設計仕様を定義する。この通知はProcessingForm画面で現在のプロセスをスキップする際に表示される確認ダイアログである。

### 本通知の処理概要

本通知は、ユーザーがProcessingForm画面で現在実行中のプロセス（サブタスク）をスキップしようとした際に、本当にスキップしてよいかを確認する機能を提供する。

**業務上の目的・背景**：StaxRipのエンコード処理は複数のプロセス（ソース読み込み、フィルタ処理、エンコード、マルチプレクス等）で構成される。特定のプロセスに問題が発生した場合や、手動で処理を制御したい場合に、現在のプロセスをスキップして次のプロセスに進むことができる。ただし、スキップは処理結果に影響を与える可能性があるため、確認ダイアログを表示して誤操作を防止する。

**通知の送信タイミング**：ProcessingForm画面でSkipメソッドが呼び出された際に表示される。これはユーザーがスキップボタンをクリックしたときに発生する。

**通知の受信者**：StaxRipアプリケーションを操作しているユーザーがダイアログを通じて直接受信する。GUI上のモーダルダイアログとして表示される。

**通知内容の概要**：「Skip current process?」という質問がタスクダイアログで表示される。ユーザーはOKでスキップを実行、Cancelでキャンセルを選択できる。

**期待されるアクション**：ユーザーはOKボタンで現在のプロセスをスキップするか、Cancelボタンでスキップをキャンセルして処理を続行する。スキップを選択した場合、ログが保存され、ProcControllerのSkipメソッドが呼び出される。

## 通知種別

アプリ内通知（Windowsタスクダイアログ）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（ユーザー応答待ち） |
| 優先度 | 高 |
| リトライ | 無 |

### 送信先決定ロジック

現在ProcessingForm画面を操作中のユーザーに対してモーダルダイアログとして直接表示される。

## 通知テンプレート

### ダイアログ表示の場合

| 項目 | 内容 |
|-----|------|
| アイコン | TaskIcon.Question（質問アイコン） |
| タイトル | Skip current process? |
| ボタン | OK / Cancel |

### 本文テンプレート

```
Skip current process?
```

### 添付ファイル

該当なし

## テンプレート変数

該当なし（固定メッセージ）

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 画面操作 | スキップボタンクリック | 常に表示 | Skipメソッド呼び出し時 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| なし | 常に表示される |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[スキップボタンクリック] --> B[Skipメソッド呼び出し]
    B --> C[MsgOK表示]
    C --> D{ユーザー選択}
    D -->|True/OK| E[Log.Save]
    D -->|False/Cancel| F[処理続行]
    E --> G[ProcController.SetLastActivation]
    G --> H[ProcController.Skip]
    H --> I[次のプロセスへ]
    F --> J[終了]
    I --> J
```

## データベース参照・更新仕様

### 参照テーブル一覧

該当なし（データベースは使用しない）

### 更新テーブル一覧

該当なし

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| ログ保存失敗 | ファイルアクセスエラー | 例外処理（詳細は別途） |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |
| リトライ間隔 | - |
| リトライ対象エラー | - |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし（ユーザー操作に応じて即時表示）

## セキュリティ考慮事項

本通知は固定のメッセージのみを表示するため、セキュリティリスクは低い。ただし、プロセスのスキップは最終的な出力結果に影響を与える可能性がある。

## 備考

- 本通知はProcessingFormクラスのSkipメソッド内で発生する
- MsgOK関数はBoolean戻り値を返し、Trueでスキップを実行
- スキップ前にLog.Save()でログを保存
- ProcController.SetLastActivation()でアクティベーション状態を更新
- 処理中断確認（No.98）とは別のメソッドで、Abortは全体中断、Skipは現在プロセスのみスキップ

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、処理コントローラの構造を理解することが重要である。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | ProcController.vb | `Source/General/ProcController.vb` | 処理コントローラの構造とSkipメソッド |

**読解のコツ**: ProcControllerは外部プロセスの実行を制御し、Skipメソッドで現在のプロセスをスキップして次のプロセスに進む。AbortとSkipの違いを理解することが重要。

#### Step 2: エントリーポイントを理解する

処理の起点となるファイル・関数を特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | ProcessingForm.vb | `Source/Forms/ProcessingForm.vb` | Skipメソッドがエントリーポイント |

**主要処理フロー**:
1. **行368**: Skipメソッド開始
2. **行369**: MsgOKダイアログ表示
3. **行370**: Log.Save()でログ保存
4. **行371**: ProcController.SetLastActivation()
5. **行372**: ProcController.Skip()でプロセススキップ

#### Step 3: 共通ダイアログ関数を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | General.vb | `Source/General/General.vb` | MsgOK関数の実装（行1257-1259） |

**主要処理フロー**:
- **行1257**: MsgOK関数定義（Boolean戻り値）
- **行1258**: Msg関数呼び出しでTaskDialogを表示

### プログラム呼び出し階層図

```
ProcessingForm.Skip()
    │
    └─ MsgOK("Skip current process?")
           │
           └─ General.Msg() → TaskDialog.Show()
                  │
                  └─ True (OK選択時)
                         │
                         ├─ Log.Save()
                         │
                         ├─ ProcController.SetLastActivation()
                         │
                         └─ ProcController.Skip()
```

### データフロー図

```
[入力]               [処理]                    [出力]

スキップボタン ───▶ MsgOK() ───▶ 確認ダイアログ表示
                       │
                       ▼
               ユーザー選択 ───▶ True/False
                       │
                       ▼ (True時)
               Log.Save() ───▶ ログファイル出力
                       │
                       ▼
               ProcController.Skip() ───▶ 次のプロセスへ
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| ProcessingForm.vb | `Source/Forms/ProcessingForm.vb` | ソース | 通知発生元の処理画面 |
| General.vb | `Source/General/General.vb` | ソース | 共通ダイアログ関数の定義 |
| TaskDialog.vb | `Source/UI/TaskDialog.vb` | ソース | タスクダイアログの実装 |
| ProcController.vb | `Source/General/ProcController.vb` | ソース | プロセス制御クラス |
| Log.vb | `Source/General/Log.vb` | ソース | ログ管理クラス |
