---
generated_at: 2026-01-21 19:24:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：100-プロファイル上書き確認

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - すべての主張に根拠が確認されました

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `Source/Forms/ProfilesForm.vb` 行426-457（bnAdd_Clickメソッド）
- E-02: `Source/General/General.vb` 行1257-1259（MsgOK関数）
- E-03: `docs/code-to-docs/通知一覧/通知一覧.csv` 行101

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 通知メッセージが「There is already a profile with this name, overwrite?」である | E-01 (行438) | ○ |
| C-02 | MsgOK関数で確認表示される | E-01 (行438), E-02 | ○ |
| C-03 | ProfilesFormのbnAdd_Clickで発生する | E-01 (行426) | ○ |
| C-04 | 同名プロファイルが存在する場合に表示される | E-01 (行437) | ○ |
| C-05 | Trueの場合に上書き処理が実行される | E-01 (行438-439) | ○ |
| C-06 | 上書き対象がremove変数に格納される | E-01 (行439) | ○ |
| C-07 | キャンセル時にExit Subで処理を中断する | E-01 (行441) | ○ |
| C-08 | 上書き対象が削除される | E-01 (行446-448) | ○ |
| C-09 | pm.Clean()でクリーンアップ処理が行われる | E-01 (行450) | ○ |
| C-10 | ObjectHelp.GetCopyでディープコピーされる | E-01 (行430) | ○ |
| C-11 | InputBox.Showで名前入力される | E-01 (行431) | ○ |
| C-12 | AddProfileMethodで新プロファイルを取得する | E-01 (行427) | ○ |
| C-13 | 新プロファイルがリストに追加される | E-01 (行451) | ○ |
| C-14 | ProfilesForm使用時に発生 | E-03 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張にソースコード根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] ProfilesForm.vbの行438でMsgOKが呼び出されていることを確認
- [ ] 名前比較ロジック（i.Name = pm.Name）が正しいことを確認
- [ ] 上書き処理（削除→追加）のシーケンスが正しいことを確認
- [ ] キャンセル時にExit Subで処理が中断されることを確認
