---
generated_at: 2026-01-21 19:05:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：101-メニューリセット確認

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  1. なし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `Source/UI/CustomMenuEditor.vb` 行960-968（ResetToolStripMenuItem_Click）
- E-02: `Source/General/General.vb` 行1257-1259（MsgOK関数）
- E-03: `Source/General/General.vb` 行1274-1282（Msg関数）
- E-04: `Source/UI/TaskDialog.vb` 行1-200（TaskDialogクラス）
- E-05: `docs/code-to-docs/通知一覧/通知一覧.csv` 行102（通知定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 通知メッセージは「Please confirm to reset the entire menu.」 | E-01 (行961) | ○ |
| C-02 | MsgOK関数でダイアログを表示 | E-01 (行961), E-02 | ○ |
| C-03 | ResetToolStripMenuItem_Clickがトリガー | E-01 (行960) | ○ |
| C-04 | OKを選択するとTreeViewをクリア | E-01 (行963) | ○ |
| C-05 | GenericMenu.DefaultMenuからデフォルトメニュー読込 | E-01 (行964) | ○ |
| C-06 | PopulateTreeViewでメニュー構成を再読込 | E-01 (行964) | ○ |
| C-07 | MsgOKはTaskIcon.QuestionとTaskButton.OkCancelを使用 | E-02 (行1258) | ○ |
| C-08 | MsgOKはDialogResult.OKとの比較結果を返す | E-02 (行1258) | ○ |
| C-09 | Msg関数がTaskDialogを生成して表示 | E-03 (行1274-1282) | ○ |
| C-10 | リセット後tv.ExpandAllで全展開 | E-01 (行966) | ○ |
| C-11 | リセット後最初のノードを選択 | E-01 (行967) | ○ |
| C-12 | CustomMenuEditor使用時の通知 | E-05 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク（全主張にソースコード根拠あり）

## 6) レビュアーチェックリスト（最小）
- [ ] CustomMenuEditor.vbの行960-968のコードと設計書の記載が一致しているか確認
- [ ] MsgOK関数の動作（Question アイコン、OK/Cancel ボタン）が正しく記載されているか確認
- [ ] デフォルトメニュー復元処理の流れが正確に記載されているか確認
