---
generated_at: 2026-01-21 19:10:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：102-デフォルト復元確認

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  1. なし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `Source/Controls/CommandLineControl.vb` 行128-133（bnContext.ClickAction）
- E-02: `Source/Controls/PreprocessingControl.vb` 行293-303（bnRestore_Click）
- E-03: `Source/UI/Menu.vb` 行683-688（TextCustomMenu.EditMenu内bnContext.ClickAction）
- E-04: `Source/Forms/MainForm.vb` 行4294-4298（ShowFilterProfilesDialog内bnContext.ClickAction）
- E-05: `Source/General/General.vb` 行1257-1259（MsgOK関数）
- E-06: `Source/General/General.vb` 行1261-1266（MsgQuestion関数）
- E-07: `Source/General/General.vb` 行1274-1282（Msg関数）
- E-08: `docs/code-to-docs/通知一覧/通知一覧.csv` 行103（通知定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 通知メッセージは「Restore defaults?」 | E-01, E-02, E-03, E-04 | ○ |
| C-02 | CommandLineControlでMsgOKを使用 | E-01 (行129) | ○ |
| C-03 | PreprocessingControlでMsgQuestionを使用 | E-02 (行294) | ○ |
| C-04 | Menu.vbでMsgOKを使用 | E-03 (行684) | ○ |
| C-05 | MainFormでMsgをTaskIcon.Warningで使用 | E-04 (行4295) | ○ |
| C-06 | 復元後「Defaults were restored.」を表示 | E-01 (行131), E-03 (行686), E-04 (行4297) | ○ |
| C-07 | CommandLineControlでRestoreFunc.Invokeでデフォルト値取得 | E-01 (行130) | ○ |
| C-08 | PreprocessingControlでDemuxer.GetDefaults()でデフォルト取得 | E-02 (行297) | ○ |
| C-09 | MsgOKはTaskIcon.QuestionとTaskButton.OkCancelを使用 | E-05 (行1258) | ○ |
| C-10 | MsgQuestionはTaskIcon.QuestionとTaskButton.OkCancelを使用 | E-06 (行1265) | ○ |
| C-11 | 複数箇所で使用される汎用的な通知 | E-08 | ○ |
| C-12 | PreprocessingControlでlv.Items.Clearでリスト初期化 | E-02 (行295) | ○ |
| C-13 | PreprocessingControlで各デマクサをAddItemで追加 | E-02 (行297-299) | ○ |
| C-14 | MainFormでgetDefaults()関数を使用 | E-04 (行4296) | ○ |
| C-15 | Msg関数がTaskDialogを生成して表示 | E-07 (行1274-1282) | ○ |
| C-16 | RestoreFuncがNothing以外の場合のみボタン表示 | E-01 (行125-136) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク（全主張にソースコード根拠あり）

## 6) レビュアーチェックリスト（最小）
- [ ] 4箇所全てのソースコード（CommandLineControl、PreprocessingControl、Menu、MainForm）の実装が設計書と一致しているか確認
- [ ] MsgOK/MsgQuestion/Msgの使い分けが正確に記載されているか確認
- [ ] 復元処理後の「Defaults were restored.」メッセージ表示が記載されているか確認
- [ ] MainFormのみTaskIcon.Warningを使用している点が記載されているか確認
