---
generated_at: 2026-01-21 19:20:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：104-Everything検索ツール導入確認

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  1. なし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `Source/Forms/AppsForm.vb` 行1017-1020（MsgQuestion voidtools）
- E-02: `Source/Forms/AppsForm.vb` 行1022-1025（MsgQuestion Everything.NET）
- E-03: `Source/Forms/AppsForm.vb` 行1063-1092（Everything DllImport定義）
- E-04: `Source/Forms/AppsForm.vb` 行1000-1002（Everything API呼び出し）
- E-05: `Source/General/General.vb` 行1268-1272（MsgQuestion 2引数版）
- E-06: `docs/code-to-docs/通知一覧/通知一覧.csv` 行105（通知定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 通知メッセージは「The Find Path feature requires...voidtools Everything」 | E-01 (行1017-1018) | ○ |
| C-02 | 2回目のダイアログで「Would you like to open...Everything.NET?」 | E-02 (行1022-1023) | ○ |
| C-03 | Everything.NETの説明「supports dark mode」が含まれる | E-02 (行1023) | ○ |
| C-04 | MsgQuestion関数でダイアログを表示 | E-01, E-02, E-05 | ○ |
| C-05 | Exception発生時にCatchブロックで処理 | E-01 (行1016) | ○ |
| C-06 | OKを選択するとvoidtools.comを開く | E-01 (行1019) | ○ |
| C-07 | OKを選択するとEverything.NET GitHubを開く | E-02 (行1024) | ○ |
| C-08 | Everything.dllをDllImportで使用 | E-03 (行1066-1092) | ○ |
| C-09 | Everything_SetSearch、Everything_SetRequestFlagsを呼び出し | E-04 (行1000-1001) | ○ |
| C-10 | Everything_Queryで検索実行 | E-04 (行1002) | ○ |
| C-11 | EVERYTHING_REQUEST_FILE_NAME定数が定義されている | E-03 (行1063) | ○ |
| C-12 | EVERYTHING_REQUEST_PATH定数が定義されている | E-03 (行1064) | ○ |
| C-13 | g.ShellExecuteでブラウザを起動 | E-01 (行1019), E-02 (行1024) | ○ |
| C-14 | AppsForm使用時の通知 | E-06 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク（全主張にソースコード根拠あり）

## 6) レビュアーチェックリスト（最小）
- [ ] AppsForm.vbの行1016-1026のコードと設計書の記載が一致しているか確認
- [ ] 2つの連続したMsgQuestionダイアログの表示順序が正確に記載されているか確認
- [ ] voidtools.comとEverything.NET GitHubのURLが正しいか確認
- [ ] Everything.dll関連のDllImport定義が記載されているか確認
