---
generated_at: 2026-01-21 19:30:00
metrics:
  claims_total: 11
  claims_with_evidence: 11
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：106-コマンドラインインポート確認

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：11 / 11、根拠なし：0
- 優先レビュー（高）
  1. なし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `Source/Forms/CommandLineForm.vb` 行62（cms.Add Import Command Line定義）
- E-02: `Source/General/General.vb` 行1268-1272（MsgQuestion 2引数版）
- E-03: `docs/code-to-docs/通知一覧/通知一覧.csv` 行107（通知定義）
- E-04: `docs/code-to-docs/画面設計書/18-CommandLineForm.md` 行151（関連通知）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 通知メッセージは「Import command line from clipboard?」 | E-01 (行62) | ○ |
| C-02 | クリップボードの内容がコンテンツとして表示される | E-01 (行62 Clipboard.GetText) | ○ |
| C-03 | MsgQuestion関数でダイアログを表示 | E-01, E-02 | ○ |
| C-04 | OKを選択するとBasicVideoEncoder.ImportCommandLineを実行 | E-01 (行62) | ○ |
| C-05 | ショートカットキーはCtrl+I | E-01 (行62 Keys.Control Or Keys.I) | ○ |
| C-06 | Symbol.Downloadアイコンを使用 | E-01 (行62 SetImage(Symbol.Download)) | ○ |
| C-07 | MsgQuestionは2引数版（title, content）を使用 | E-02 (行1268-1272) | ○ |
| C-08 | メニュー項目名は「Import Command Line...」 | E-01 (行62) | ○ |
| C-09 | Clipboard.GetText()でクリップボード内容を取得 | E-01 (行62) | ○ |
| C-10 | paramsオブジェクトに設定を反映 | E-01 (行62 params) | ○ |
| C-11 | CommandLineForm使用時の通知 | E-03, E-04 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク（全主張にソースコード根拠あり）

## 6) レビュアーチェックリスト（最小）
- [ ] CommandLineForm.vbの行62のコードと設計書の記載が一致しているか確認
- [ ] MsgQuestionの2引数版（title, content）の使用方法が正確に記載されているか確認
- [ ] ショートカットキー（Ctrl+I）とアイコン（Symbol.Download）が正確に記載されているか確認
- [ ] BasicVideoEncoder.ImportCommandLineの呼び出しが記載されているか確認
