---
generated_at: 2026-01-21 10:30:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：11-抽出失敗通知

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `Source/General/ToolUpdate.vb` 行82-86（抽出失敗時のMsgError呼び出し）
- E-02: `Source/General/ToolUpdate.vb` 行68-71（ファイル拡張子チェック）
- E-03: `Source/General/ToolUpdate.vb` 行73（ExtractDir設定）
- E-04: `Source/General/ToolUpdate.vb` 行75-87（7-Zipプロセス起動・終了コードチェック）
- E-05: `Source/General/ToolUpdate.vb` 行24-45（Updateメソッド）
- E-06: `Source/General/ToolUpdate.vb` 行47-66（Downloadメソッド）
- E-07: `docs/code-to-docs/通知一覧/通知一覧.csv` 行12（通知一覧での定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 通知名は「Extraction failed with error exit code」 | E-01, E-07 | ○ |
| C-02 | ToolUpdate.Extractメソッドで発生 | E-01 | ○ |
| C-03 | Process.ExitCodeが0以外の場合にトリガー | E-04 | ○ |
| C-04 | MsgError関数で表示 | E-01 | ○ |
| C-05 | 終了コードがメッセージに含まれる | E-01 | ○ |
| C-06 | 7z/zip以外のファイルは処理対象外 | E-02 | ○ |
| C-07 | UpdatePackageDialogが先に呼ばれる | E-01 | ○ |
| C-08 | 通知後にExit Subで処理中断 | E-01 | ○ |
| C-09 | Package.SevenZip.Pathで7-Zipを実行 | E-04 | ○ |
| C-10 | 同期的なモーダルダイアログ | E-01 | ○ |
| C-11 | リトライ機能なし | E-01 | ○ |
| C-12 | ToolUpdate使用時に発生 | E-07 | ○ |
| C-13 | Downloadメソッドから呼び出される | E-06 | ○ |
| C-14 | UpdateメソッドがHTTPでURLを取得 | E-05 | ○ |
| C-15 | 抽出先はDownloadFile.Dirとベース名の組み合わせ | E-03 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張にソースコードの根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] ToolUpdate.vbの行82-86を確認し、MsgErrorの呼び出しが正しく記載されているか
- [ ] 7-Zipの終了コードの意味が備考に正しく記載されているか
- [ ] 処理フローがソースコードと一致しているか
