---
generated_at: 2026-01-21 10:35:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：12-抽出後ファイル不在通知

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `Source/General/ToolUpdate.vb` 行118-122（ファイル不在時のMsgError呼び出し）
- E-02: `Source/General/ToolUpdate.vb` 行89（最初のファイル存在チェック）
- E-03: `Source/General/ToolUpdate.vb` 行90-116（サブディレクトリ検索ロジック）
- E-04: `Source/General/ToolUpdate.vb` 行92-96（サブディレクトリ検索とIgnoreフィルタ）
- E-05: `Source/General/ToolUpdate.vb` 行98-112（複数候補時のTaskDialog表示）
- E-06: `docs/code-to-docs/通知一覧/通知一覧.csv` 行13（通知一覧での定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 通知メッセージは「File missing after extraction.」 | E-01, E-06 | ○ |
| C-02 | ToolUpdate.Extractメソッドで発生 | E-01 | ○ |
| C-03 | 抽出成功後にファイル存在チェックが行われる | E-02 | ○ |
| C-04 | サブディレクトリ検索機能がある | E-03 | ○ |
| C-05 | 複数候補時はTaskDialogで選択させる | E-05 | ○ |
| C-06 | Ignore関数でフィルタリングされる | E-04 | ○ |
| C-07 | 最終チェック後にMsgErrorを呼び出す | E-01 | ○ |
| C-08 | UpdatePackageDialogが先に呼ばれる | E-01 | ○ |
| C-09 | Exit Subで処理中断 | E-01 | ○ |
| C-10 | 固定メッセージでテンプレート変数なし | E-01 | ○ |
| C-11 | ToolUpdate使用時に発生 | E-06 | ○ |
| C-12 | 1候補のみの場合は自動選択 | E-03 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張にソースコードの根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] ToolUpdate.vbの行118-122を確認し、MsgErrorの呼び出しが正しく記載されているか
- [ ] サブディレクトリ検索ロジック（行90-116）が正しく説明されているか
- [ ] 処理フローがソースコードと一致しているか
