---
generated_at: 2026-01-21 10:55:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：16-スクリプトエラー通知

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `Source/Forms/PreviewForm.vb` 行307（PreviewForm.OpenでのMsgError）
- E-02: `Source/Forms/PreviewForm.vb` 行356（PreviewForm.ReloadでのMsgError）
- E-03: `Source/Forms/MainForm.vb` 行2919（OpenVideoSourceFilesでのMsgError）
- E-04: `Source/Forms/MainForm.vb` 行4017（ShowPreviewでのMsgError）
- E-05: `Source/Forms/MainForm_Assistant.vb` 行478（アシスタントでのMsgError）
- E-06: `Source/Forms/CropForm.vb` 行311（CropFormでのTaskDialog）
- E-07: `Source/Forms/CodeEditor.vb` 行442（CodeEditorでのMsgError）
- E-08: `Source/General/GlobalClass.vb` 行528（ProcessJobでのErrorAbortException）
- E-09: `Source/General/GlobalClass.vb` 行1434（SourceValidOrShowErrorでのMsgError）
- E-10: `Source/General/GlobalClass.vb` 行2100, 2124（DisplayHDRInfoでのMsgError）
- E-11: `docs/code-to-docs/通知一覧/通知一覧.csv` 行17（通知一覧での定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 通知タイトルは「Script Error」 | E-01, E-06, E-11 | ○ |
| C-02 | 複数箇所で使用される共通エラー通知 | E-01〜E-10 | ○ |
| C-03 | PreviewForm.Openで発生（行307） | E-01 | ○ |
| C-04 | PreviewForm.Reloadで発生（行356） | E-02 | ○ |
| C-05 | MainForm.OpenVideoSourceFilesで発生（行2919） | E-03 | ○ |
| C-06 | MainForm.ShowPreviewで発生（行4017） | E-04 | ○ |
| C-07 | MainForm_Assistantで発生（行478） | E-05 | ○ |
| C-08 | CropFormでTaskDialogを使用（行311） | E-06 | ○ |
| C-09 | CropFormでOK/Exitボタン表示 | E-06 | ○ |
| C-10 | CodeEditorで発生（行442） | E-07 | ○ |
| C-11 | GlobalClass.ProcessJobでErrorAbortException（行528） | E-08 | ○ |
| C-12 | GlobalClass.SourceValidOrShowErrorで発生（行1434） | E-09 | ○ |
| C-13 | GlobalClass.DisplayHDRInfoで発生（行2100, 2124） | E-10 | ○ |
| C-14 | script.Error <> "" の条件チェック | E-01, E-02, E-08 | ○ |
| C-15 | MsgError関数で表示 | E-01〜E-05, E-07, E-09, E-10 | ○ |
| C-16 | タイムアウト付きで表示される場合がある | E-03 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張にソースコードの根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] 複数の発生箇所（10箇所）が正しく列挙されているか
- [ ] CropFormのTaskDialogパターンが正しく説明されているか
- [ ] ErrorAbortExceptionパターン（GlobalClass.ProcessJob）が正しく説明されているか
