---
generated_at: 2026-01-21 11:00:00
metrics:
  claims_total: 10
  claims_with_evidence: 10
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：17-ソースフィルタエラー通知

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：10 / 10、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `Source/Video/VideoScript.vb` 行774（MsgError呼び出し）
- E-02: `Source/Video/VideoScript.vb` 行773（条件チェック）
- E-03: `Source/Video/VideoScript.vb` 行775（デフォルトフィルタへのリセット）
- E-04: `Source/Video/VideoScript.vb` 行766-783（Edit()メソッド全体）
- E-05: `Source/Video/VideoScript.vb` 行771（form.GetFilters()呼び出し）
- E-06: `docs/code-to-docs/通知一覧/通知一覧.csv` 行18（通知一覧での定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 通知メッセージは「The first filter must be a source filter.」 | E-01, E-06 | ○ |
| C-02 | MsgError関数で表示 | E-01 | ○ |
| C-03 | ProfileVideoScript.Edit()メソッドで発生 | E-04 | ○ |
| C-04 | VideoScript.vbの行774が発生箇所 | E-01 | ○ |
| C-05 | Filters.Count = 0 Or Filters(0).Category <> "Source" の条件 | E-02 | ○ |
| C-06 | 通知後にGetDefaults(0).Filtersでリセット | E-03 | ○ |
| C-07 | CodeEditorダイアログでOK時に発生 | E-04 | ○ |
| C-08 | form.GetFilters()でフィルタを取得 | E-05 | ○ |
| C-09 | VideoScript使用時に発生 | E-06 | ○ |
| C-10 | 固定メッセージでテンプレート変数なし | E-01 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張にソースコードの根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] VideoScript.vbの行773-775を確認し、条件とMsgErrorの呼び出しが正しく記載されているか
- [ ] デフォルトフィルタへのリセット処理が正しく説明されているか
- [ ] 処理フローがソースコードと一致しているか
