---
generated_at: 2026-01-21 11:05:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：18-ファイル移動エラー通知

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `Source/Video/FrameServer.vb` 行529-530（MsgError呼び出し）
- E-02: `Source/Video/FrameServer.vb` 行522-533（MoveFilesメソッド全体）
- E-03: `Source/Video/FrameServer.vb` 行527（FileHelp.Move呼び出し）
- E-04: `Source/Video/FrameServer.vb` 行528（Catch ex As Exception）
- E-05: `Source/Video/FrameServer.vb` 行535以降（AviSynthToolPathメソッド）
- E-06: `docs/code-to-docs/通知一覧/通知一覧.csv` 行19（通知一覧での定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 通知メッセージは「Could not move file from:...」 | E-01, E-06 | ○ |
| C-02 | MsgError関数で表示 | E-01 | ○ |
| C-03 | FrameServer.MoveFilesメソッドで発生 | E-02 | ○ |
| C-04 | FrameServer.vbの行529-530が発生箇所 | E-01 | ○ |
| C-05 | FileHelp.Move()が例外をスロー時に発生 | E-03, E-04 | ○ |
| C-06 | ソースパス、宛先パス、例外メッセージが含まれる | E-01 | ○ |
| C-07 | Catch ex As Exceptionで捕捉 | E-04 | ○ |
| C-08 | エラー後も次のファイル処理は継続 | E-02 | ○ |
| C-09 | AviSynthToolPathから呼び出される | E-05 | ○ |
| C-10 | FrameServer使用時に発生 | E-06 | ○ |
| C-11 | ffmpeg, x264, x265のファイル移動で使用 | E-05 | ○ |
| C-12 | For Each構造でファイルをループ処理 | E-02 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張にソースコードの根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] FrameServer.vbの行529-530を確認し、MsgErrorの呼び出しが正しく記載されているか
- [ ] メッセージフォーマット（src, dest, ex.Message）が正しく説明されているか
- [ ] AviSynthToolPathメソッドからの呼び出し関係が正しく説明されているか
