---
generated_at: 2026-01-21 11:10:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：19-プロジェクト不在通知

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `Source/General/GlobalClass.vb` 行482（MsgError呼び出し）
- E-02: `Source/General/GlobalClass.vb` 行481（File.Exists条件チェック）
- E-03: `Source/General/GlobalClass.vb` 行483（Exit Sub）
- E-04: `Source/General/GlobalClass.vb` 行479-507（ProcessJobメソッド冒頭部分）
- E-05: `docs/code-to-docs/通知一覧/通知一覧.csv` 行20（通知一覧での定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 通知タイトルは「Project file not found!」 | E-01, E-05 | ○ |
| C-02 | MsgError関数で表示 | E-01 | ○ |
| C-03 | GlobalClass.ProcessJobメソッドで発生 | E-04 | ○ |
| C-04 | GlobalClass.vbの行482が発生箇所 | E-01 | ○ |
| C-05 | Not File.Exists(jobPath)の条件 | E-02 | ○ |
| C-06 | jobPathがメッセージに含まれる | E-01 | ○ |
| C-07 | g.RunTask()でUIスレッドで実行 | E-01 | ○ |
| C-08 | Exit Subでジョブをスキップ | E-03 | ○ |
| C-09 | 「could not be found and got skipped!」という文言 | E-01 | ○ |
| C-10 | GlobalClass使用時に発生 | E-05 | ○ |
| C-11 | ジョブ処理開始時に発生 | E-04 | ○ |
| C-12 | ファイル存在時は通知しない | E-02 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張にソースコードの根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] GlobalClass.vbの行481-483を確認し、条件とMsgErrorの呼び出しが正しく記載されているか
- [ ] g.RunTask()によるUIスレッド実行が正しく説明されているか
- [ ] 処理フローがソースコードと一致しているか
