---
generated_at: 2026-01-21 19:05:00
metrics:
  claims_total: 22
  claims_with_evidence: 21
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：2-MsgError.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：21 / 22、根拠なし：1
- 優先レビュー（高）
  1. **C-22**: セキュリティ考慮事項（スタックトレース情報）の記載 - 推測による記載

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `Source/General/General.vb` 行1222-1224（MsgErrorオーバーロード1）
- E-02: `Source/General/General.vb` 行1226-1240（MsgErrorメイン実装）
- E-03: `Source/UI/TaskDialog.vb` 行16（Timeoutプロパティ）
- E-04: `Source/UI/TaskDialog.vb` 行183-232（タイムアウト処理）
- E-05: `Source/UI/TaskDialog.vb` 行454-466（ShowCopyButtonプロパティ）
- E-06: `Source/UI/TaskDialog.vb` 行479-491（GetText()メソッド）
- E-07: `Source/UI/TaskDialog.vb` 行85（TaskIcon.Error時のStockIcon取得）
- E-08: `Source/General/StaxRipUpdate.vb` 行148（"Download failed!"使用箇所）
- E-09: `Source/General/ToolUpdate.vb` 行58（"Downloaded file is missing."使用箇所）
- E-10: `Source/General/ToolUpdate.vb` 行84（"Extraction failed with error exit code"使用箇所）
- E-11: `Source/General/ToolUpdate.vb` 行120（"File missing after extraction."使用箇所）
- E-12: `Source/General/General.vb` 行1134（"Parameter mismatch..."使用箇所）
- E-13: `docs/code-to-docs/通知一覧/通知一覧.csv` 行3（通知No.2の定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | MsgErrorはMainModuleに定義されたグローバル関数 | E-01, E-02 | ○ |
| C-02 | MsgErrorには複数のオーバーロードが存在 | E-01, E-02 | ○ |
| C-03 | timeout < 0の場合は早期リターン | E-02（行1227） | ○ |
| C-04 | titleが空の場合はcontentをtitleとして使用 | E-02（行1228-1229） | ○ |
| C-05 | title/content両方が空の場合は表示しない | E-02（行1229） | ○ |
| C-06 | TaskIcon.Errorが設定される | E-02（行1235） | ○ |
| C-07 | ShowCopyButton = Trueが設定される | E-02（行1236） | ○ |
| C-08 | Timeoutプロパティで自動クローズ秒数を設定 | E-02, E-03 | ○ |
| C-09 | タイムアウト時にバックグラウンドタスクでカウントダウン | E-04 | ○ |
| C-10 | カウントダウン中はボタンテキストに残り秒数を表示 | E-04（行205-209） | ○ |
| C-11 | タイムアウト後に自動的にダイアログをクローズ | E-04（行224-228） | ○ |
| C-12 | ShowCopyButtonでblCopyMessageリンクボタンが表示される | E-05 | ○ |
| C-13 | コピー時はSTAタスクでClipboard.SetTextを実行 | E-05（行460） | ○ |
| C-14 | コピー完了後にMsgInfoで通知を表示 | E-05（行462） | ○ |
| C-15 | GetText()でTitle/Content/ExpandedContentを結合 | E-06 | ○ |
| C-16 | ダウンロード失敗時に"Download failed!"を表示 | E-08 | ○ |
| C-17 | ファイル不在時に"Downloaded file is missing."を表示 | E-09 | ○ |
| C-18 | 抽出失敗時に"Extraction failed with error exit code"を表示 | E-10 | ○ |
| C-19 | 抽出後ファイル不在時に"File missing after extraction."を表示 | E-11 | ○ |
| C-20 | パラメータ不一致時に"Parameter mismatch..."を表示 | E-12 | ○ |
| C-21 | 通知カテゴリは「エラー通知」である | E-13 | ○ |
| C-22 | スタックトレース情報がクリップボードにコピーされる可能性 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- スタックトレース情報のコピーに関するセキュリティ考慮は明示的なコード根拠がない
  - 候補：g.ShowException()の実装 / エラーハンドリングポリシー文書

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - MsgError関数の実装は明確で、根拠となるコードが確認済み
- 0: 低リスク - タイムアウト機能の動作は詳細にコードで確認済み
- 0: 低リスク - ShowCopyButton機能の動作はコードで確認済み
- 1: 中リスク - セキュリティ考慮事項は推測に基づく（実運用時に確認推奨）

## 6) レビュアーチェックリスト（最小）
- [ ] MsgError関数のオーバーロードがGeneral.vb行1222-1240と一致するか確認
- [ ] timeout < 0での早期リターン動作が正しいか確認
- [ ] ShowCopyButton設定によるコピー機能が正しく動作するか確認
- [ ] タイムアウト処理のカウントダウン表示が意図通りか確認
- [ ] 主要な使用箇所（StaxRipUpdate.vb, ToolUpdate.vb）が網羅されているか確認
