---
generated_at: 2026-01-21 11:15:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：20-ソースファイル不在通知

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `Source/General/GlobalClass.vb` 行494（バッチモードでのMsgError呼び出し）
- E-02: `Source/General/GlobalClass.vb` 行504（通常モードでのMsgError呼び出し）
- E-03: `Source/General/GlobalClass.vb` 行490-496（バッチモードの処理）
- E-04: `Source/General/GlobalClass.vb` 行502-506（通常モードの処理）
- E-05: `Source/General/GlobalClass.vb` 行491（missingFilesのWhere句）
- E-06: `Source/General/GlobalClass.vb` 行503（File.Exists条件）
- E-07: `docs/code-to-docs/通知一覧/通知一覧.csv` 行21（通知一覧での定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 通知タイトルは「Source file not found!」 | E-01, E-02, E-07 | ○ |
| C-02 | MsgError関数で表示 | E-01, E-02 | ○ |
| C-03 | GlobalClass.ProcessJobメソッドで発生 | E-03, E-04 | ○ |
| C-04 | 行494がバッチモードの発生箇所 | E-01 | ○ |
| C-05 | 行504が通常モードの発生箇所 | E-02 | ○ |
| C-06 | バッチモードではp.SourceFilesをチェック | E-03, E-05 | ○ |
| C-07 | 通常モードではp.SourceFileをチェック | E-04, E-06 | ○ |
| C-08 | missingFiles.Join(BR)で複数ファイルを表示 | E-01 | ○ |
| C-09 | g.RunTask()でUIスレッドで実行 | E-01, E-02 | ○ |
| C-10 | Exit Subでジョブをスキップ | E-03, E-04 | ○ |
| C-11 | 「could not be found and got skipped!」という文言 | E-01, E-02 | ○ |
| C-12 | GlobalClass使用時に発生 | E-07 | ○ |
| C-13 | p.BatchModeで分岐 | E-03 | ○ |
| C-14 | Where(Not FileExists)で不在ファイルを抽出 | E-05 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張にソースコードの根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] GlobalClass.vbの行490-496（バッチモード）と行502-506（通常モード）を確認し、正しく記載されているか
- [ ] バッチモードと通常モードの違いが正しく説明されているか
- [ ] 処理フローがソースコードと一致しているか
