---
generated_at: 2026-01-21 19:00:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：21-ソースフィルタ未検出警告

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `Source/General/GlobalClass.vb` 行808-810（ソースフィルタ確認処理）
- E-02: `Source/General/General.vb` 行1245-1255（MsgWarn関数定義）
- E-03: `Source/General/General.vb` 行1274-1279（Msg関数定義）
- E-04: `Source/General/Misc.vb` 行18-22（グローバル変数定義）
- E-05: `docs/code-to-docs/通知一覧/通知一覧.csv` 行22（通知定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 通知メッセージは「No active filter of category 'Source' found.」である | E-01 (行809) | ○ |
| C-02 | MsgWarn関数で警告ダイアログを表示する | E-02 (行1245-1255) | ○ |
| C-03 | TaskIcon.Warningアイコンが使用される | E-02 (行1250) | ○ |
| C-04 | TaskButton.OKボタンが表示される | E-02 (行1250) | ○ |
| C-05 | p.Script.IsFilterActive("Source")で判定する | E-01 (行808) | ○ |
| C-06 | 判定がFalseの場合に通知が発生する | E-01 (行808-809) | ○ |
| C-07 | 通知後にReturn Falseで処理中断を通知する | E-01 (行810) | ○ |
| C-08 | GlobalClass使用時に発生する通知である | E-05 (行22備考) | ○ |
| C-09 | 通知カテゴリは「ソースフィルタ未検出警告」である | E-05 (行22) | ○ |
| C-10 | グローバル変数pはProjectインスタンスである | E-04 (行20) | ○ |
| C-11 | グローバル変数gはGlobalClassインスタンスである | E-04 (行19) | ○ |
| C-12 | 同期的に表示される（モーダルダイアログ） | E-03 (行1275-1279) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードにより裏付けられている

## 6) レビュアーチェックリスト（最小）
- [ ] GlobalClass.vb 行808-810の実装が設計書の記述と一致しているか確認
- [ ] MsgWarn関数の動作が期待通りか確認
- [ ] IsFilterActive関数の実装を確認（VideoScript.vb）
