---
generated_at: 2026-01-21 19:10:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：23-オーディオ再生エラー通知

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `Source/General/GlobalClass.vb` 行833-843（PlayAudio関数）
- E-02: `Source/General/General.vb` 行1222-1241（MsgError関数定義）
- E-03: `docs/code-to-docs/通知一覧/通知一覧.csv` 行24（通知定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 通知メッセージは「Unable to play audio.」である | E-01 (行841) | ○ |
| C-02 | MsgError関数でエラーダイアログを表示する | E-01, E-02 | ○ |
| C-03 | FileTypes.AudioRaw.Containsで判定する | E-01 (行834) | ○ |
| C-04 | ap.File = p.FirstOriginalSourceFileで元ソースファイルを判定する | E-01 (行836) | ○ |
| C-05 | ap.Streams.Count > 0でストリーム存在を判定する | E-01 (行836) | ○ |
| C-06 | FileTypes.Audio.Containsで標準Audio形式を判定する | E-01 (行838) | ○ |
| C-07 | Else分岐でエラーが発生する | E-01 (行840-841) | ○ |
| C-08 | GlobalClass使用時に発生する通知である | E-03 (行24備考) | ○ |
| C-09 | 通知カテゴリは「オーディオ再生エラー通知」である | E-03 (行24) | ○ |
| C-10 | mpvnetプレイヤーを使用する | E-01 (行835, 837, 839) | ○ |
| C-11 | g.ShellExecuteで外部プレイヤーを起動する | E-01 (行835, 837, 839) | ○ |
| C-12 | --audio-delayオプションでディレイを設定する | E-01 (行839) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードにより裏付けられている

## 6) レビュアーチェックリスト（最小）
- [ ] GlobalClass.vb 行833-843の実装が設計書の記述と一致しているか確認
- [ ] FileTypes.AudioRaw、FileTypes.Audioの定義内容を確認
- [ ] mpvnetパッケージが正しくインストールされているか確認
