---
generated_at: 2026-01-21 19:25:00
metrics:
  claims_total: 11
  claims_with_evidence: 11
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：26-ソース読込失敗警告

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：11 / 11、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `Source/General/GlobalClass.vb` 行1422-1439（IsValidSource関数）
- E-02: `Source/General/GlobalClass.vb` 行1427（MsgWarn呼び出し）
- E-03: `Source/General/General.vb` 行1245-1255（MsgWarn関数定義）
- E-04: `docs/code-to-docs/通知一覧/通知一覧.csv` 行27（通知定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 通知メッセージは「Failed to load source.」である | E-02 (行1427) | ○ |
| C-02 | MsgWarn関数で警告ダイアログを表示する | E-02, E-03 | ○ |
| C-03 | p.SourceScript.Info.FrameCount = 0で判定する | E-01 (行1425) | ○ |
| C-04 | warnパラメータで警告表示を制御する | E-01 (行1422, 1426) | ○ |
| C-05 | p.SourceScript.Synchronizeを呼び出す | E-01 (行1423) | ○ |
| C-06 | 判定後にReturn Falseで処理中断を通知する | E-01 (行1430) | ○ |
| C-07 | GlobalClass使用時に発生する通知である | E-04 (行27備考) | ○ |
| C-08 | 通知カテゴリは「ソース読込失敗警告」である | E-04 (行27) | ○ |
| C-09 | スクリプトエラーがある場合は別途MsgErrorで表示する | E-01 (行1433-1436) | ○ |
| C-10 | Optional warnパラメータのデフォルトはTrueである | E-01 (行1422) | ○ |
| C-11 | Synchronize(False, False)で呼び出す | E-01 (行1423) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードにより裏付けられている

## 6) レビュアーチェックリスト（最小）
- [ ] GlobalClass.vb 行1422-1439の実装が設計書の記述と一致しているか確認
- [ ] VideoScript.Synchronize関数の動作を確認
- [ ] FrameCount取得ロジックを確認
