---
generated_at: 2026-01-21 19:10:00
metrics:
  claims_total: 16
  claims_with_evidence: 15
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：3-MsgWarn.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：15 / 16、根拠なし：1
- 優先レビュー（高）
  1. **C-16**: ShownMessagesの外部アクセス不可に関するセキュリティ記載 - 仕様として明示的な根拠なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `Source/General/General.vb` 行1243（ShownMessages変数定義）
- E-02: `Source/General/General.vb` 行1245-1255（MsgWarn関数定義）
- E-03: `Source/UI/TaskDialog.vb` 行580-587（TaskIcon列挙型）
- E-04: `Source/UI/TaskDialog.vb` 行82-83（TaskIcon.Warning時のStockIcon取得）
- E-05: `Source/General/General.vb` 行1105-1109（CommandManager.AddCommandでのMsgWarn使用）
- E-06: `docs/code-to-docs/通知一覧/通知一覧.csv` 行4（通知No.3の定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | MsgWarnはMainModuleに定義されたグローバル関数 | E-02 | ○ |
| C-02 | MsgWarnはtext, content, onlyOnceの3パラメータを受け取る | E-02（行1245） | ○ |
| C-03 | onlyOnceのデフォルト値はFalse | E-02（行1245） | ○ |
| C-04 | ShownMessagesはPrivate Sharedな静的変数 | E-01 | ○ |
| C-05 | onlyOnce=Trueかつ表示済みの場合は早期リターン | E-02（行1246-1248） | ○ |
| C-06 | ShownMessages.Contains(text + content)で重複チェック | E-02（行1246） | ○ |
| C-07 | Msg関数がTaskIcon.Warning, TaskButton.OKで呼び出される | E-02（行1250） | ○ |
| C-08 | onlyOnce=Trueの場合、表示後にShownMessagesに記録 | E-02（行1252-1254） | ○ |
| C-09 | ShownMessages += text + contentで連結保存 | E-02（行1253） | ○ |
| C-10 | TaskIcon.WarningでStockIconIdentifier.Warningを使用 | E-04 | ○ |
| C-11 | 通知カテゴリは「警告通知」である | E-06 | ○ |
| C-12 | onlyOnceフラグで重複表示抑制可能 | E-06 | ○ |
| C-13 | CommandManager.AddCommandで重複コマンド警告を表示 | E-05 | ○ |
| C-14 | Warningアイコン（黄色い三角形）が表示される | E-03, E-04 | ○ |
| C-15 | アプリケーション再起動でShownMessagesがリセットされる | E-01（Private Shared変数のため） | ○ |
| C-16 | ShownMessagesは外部からアクセスできない | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- ShownMessagesの外部アクセス不可は、Private修飾子から推測されるが、セキュリティ要件として明示された根拠はない
  - 候補：セキュリティ設計書 / コーディング規約

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - MsgWarn関数の実装は明確で、根拠となるコードが確認済み
- 0: 低リスク - onlyOnceフラグの動作はコードで確認済み
- 0: 低リスク - ShownMessagesの重複チェックロジックは明確

## 6) レビュアーチェックリスト（最小）
- [ ] MsgWarn関数の定義がGeneral.vb行1245-1255と一致するか確認
- [ ] onlyOnceフラグによる重複抑制が正しく動作するか確認
- [ ] ShownMessagesがPrivate Sharedとして定義されているか確認
- [ ] TaskIcon.Warningの設定が正しいか確認
