---
generated_at: 2026-01-21 19:45:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：30-アシスタント指示通知

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `Source/Forms/PreviewForm.vb` 行713-748（CreateJobForEachSelection関数）
- E-02: `Source/Forms/PreviewForm.vb` 行715-717（前提条件チェック）
- E-03: `Source/Forms/PreviewForm.vb` 行719-721（MsgError呼び出し）
- E-04: `Source/General/General.vb` 行1222-1241（MsgError関数定義）
- E-05: `docs/code-to-docs/通知一覧/通知一覧.csv` 行31（通知定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 通知メッセージは「Follow assistant message in main dialog.」である | E-03 (行720) | ○ |
| C-02 | MsgError関数でエラーダイアログを表示する | E-03, E-04 | ○ |
| C-03 | g.MainForm.AssistantPassedで判定する | E-03 (行719) | ○ |
| C-04 | Not g.MainForm.AssistantPassedの場合にエラーが発生する | E-03 (行719-720) | ○ |
| C-05 | Exit Subで処理を終了する | E-03 (行721) | ○ |
| C-06 | p.SourceFile = ""の場合は先にExit Subする | E-02 (行715) | ○ |
| C-07 | p.Ranges.Count = 0の場合は先にExit Subする | E-02 (行715) | ○ |
| C-08 | PreviewForm使用時に発生する通知である | E-05 (行31備考) | ○ |
| C-09 | 通知カテゴリは「アシスタント指示通知」である | E-05 (行31) | ○ |
| C-10 | <Command>属性でコマンドとして定義されている | E-01 (行713) | ○ |
| C-11 | CreateJobForEachSelection関数内で発生する | E-01 (行714) | ○ |
| C-12 | アシスタントパス後にジョブ作成処理が実行される | E-01 (行724-747) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードにより裏付けられている

## 6) レビュアーチェックリスト（最小）
- [ ] PreviewForm.vb 行713-748の実装が設計書の記述と一致しているか確認
- [ ] MainForm.AssistantPassedプロパティの実装を確認
- [ ] アシスタント機能の全体的な動作を確認
