---
generated_at: 2026-01-21 10:34:00
metrics:
  claims_total: 9
  claims_with_evidence: 9
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：33-機能廃止通知

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：9 / 9、根拠なし：0
- 優先レビュー（高）
  - なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `Source/General/GlobalCommands.vb` 行939-942 - ShowRemovedFunctionalityMessage()メソッド定義
- E-02: `Source/General/GlobalCommands.vb` 行941 - MsgWarn呼び出し
- E-03: `Source/General/General.vb` 行1245-1255 - MsgWarn関数定義
- E-04: `Source/General/General.vb` 行1274-1282 - Msg関数定義
- E-05: `docs/code-to-docs/通知一覧/通知一覧.csv` 行34 - 通知定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 通知メッセージは「Functionality is no longer available.」である | E-02, E-05 | ○ |
| C-02 | ShowRemovedFunctionalityMessage()メソッドで表示される | E-01, E-02 | ○ |
| C-03 | MsgWarn関数を使用する | E-02, E-03 | ○ |
| C-04 | TaskIcon.Warningを使用する | E-03 (行1250) | ○ |
| C-05 | TaskButton.OKを使用する | E-03 (行1250) | ○ |
| C-06 | 廃止された機能が使用された際に表示される | E-01, E-05 | ○ |
| C-07 | CommandAttributeで説明が定義されている | E-01 (行939) | ○ |
| C-08 | 同期方式で表示される | E-04 | ○ |
| C-09 | GlobalCommands使用時に表示 | E-05 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張にコード根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] GlobalCommands.vb の ShowRemovedFunctionalityMessage()メソッドを確認
- [ ] MsgWarn関数の動作を確認
- [ ] 廃止機能の呼び出し元を確認
