---
generated_at: 2026-01-21 10:36:00
metrics:
  claims_total: 11
  claims_with_evidence: 11
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：34-無効文字警告

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：11 / 11、根拠なし：0
- 優先レビュー（高）
  - なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `Source/General/Project.vb` 行283-300 - TargetFileプロパティ定義
- E-02: `Source/General/Project.vb` 行291 - 無効文字チェック処理
- E-03: `Source/General/Project.vb` 行292 - MsgWarn呼び出し
- E-04: `Source/General/Project.vb` 行293 - Exit Property
- E-05: `Source/General/General.vb` 行1245-1255 - MsgWarn関数定義
- E-06: `docs/code-to-docs/通知一覧/通知一覧.csv` 行35 - 通知定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 通知メッセージは「Filename contains invalid characters.」である | E-03, E-06 | ○ |
| C-02 | TargetFileプロパティのSetterで表示される | E-01, E-02 | ○ |
| C-03 | MsgWarn関数を使用する | E-03, E-05 | ○ |
| C-04 | TaskIcon.Warningを使用する | E-05 | ○ |
| C-05 | 無効文字検出時に設定が拒否される | E-04 | ○ |
| C-06 | Path.GetInvalidPathChars()を使用する | E-02 | ○ |
| C-07 | IsValidFileName()を使用する | E-02 | ○ |
| C-08 | 空文字列の場合は検証スキップ | E-02 | ○ |
| C-09 | 同一値の場合は検証スキップ | E-01 (行290) | ○ |
| C-10 | PropertyChangedが通知される（成功時） | E-01 (行297) | ○ |
| C-11 | Project使用時に表示 | E-06 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張にコード根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] Project.vb の TargetFileプロパティの検証ロジックを確認
- [ ] 無効文字の定義を確認
- [ ] IsValidFileName()メソッドの実装を確認
