---
generated_at: 2026-01-21 10:38:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：35-字幕形式エラー通知

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  - なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `Source/General/Project.vb` 行302-363 - AddHardcodedSubtitleFilterメソッド定義
- E-02: `Source/General/Project.vb` 行303 - IsAviSynthチェック
- E-03: `Source/General/Project.vb` 行306-316 - AviSynth用拡張子チェック
- E-04: `Source/General/Project.vb` 行313 - MsgError呼び出し
- E-05: `Source/General/General.vb` 行1222-1240 - MsgError関数定義
- E-06: `docs/code-to-docs/通知一覧/通知一覧.csv` 行36 - 通知定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 通知メッセージは「Only idx, srt and ass file types are supported.」である | E-04, E-06 | ○ |
| C-02 | AddHardcodedSubtitleFilter()メソッドで表示される | E-01, E-04 | ○ |
| C-03 | AviSynth環境でのみ表示される | E-02, E-03 | ○ |
| C-04 | idx拡張子はVobSubフィルタを使用 | E-03 (行306) | ○ |
| C-05 | srt/ass拡張子はTextSubフィルタを使用 | E-03 (行308) | ○ |
| C-06 | MsgError関数を使用する | E-04, E-05 | ○ |
| C-07 | TaskIcon.Errorを使用する | E-05 (行1235) | ○ |
| C-08 | showErrorMsgフラグで表示制御 | E-03 (行312) | ○ |
| C-09 | 非対応形式の場合Exit Subで終了 | E-03 (行315) | ○ |
| C-10 | VapourSynth環境では別処理 | E-01 (行327-362) | ○ |
| C-11 | 同期方式で表示される | E-05 | ○ |
| C-12 | Project使用時に表示 | E-06 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張にコード根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] Project.vb の AddHardcodedSubtitleFilterメソッドを確認
- [ ] AviSynth/VapourSynthの分岐ロジックを確認
- [ ] 対応する字幕形式の一覧を確認
