---
generated_at: 2026-01-21 10:40:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：36-字幕形式エラー通知（sup含む）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `Source/General/Project.vb` 行302-363 - AddHardcodedSubtitleFilterメソッド定義
- E-02: `Source/General/Project.vb` 行327-362 - VapourSynth分岐処理
- E-03: `Source/General/Project.vb` 行330-351 - VapourSynth用拡張子チェック
- E-04: `Source/General/Project.vb` 行350 - MsgError呼び出し
- E-05: `Source/General/Project.vb` 行335-345 - ass用レンダラー選択
- E-06: `Source/General/General.vb` 行1222-1240 - MsgError関数定義
- E-07: `docs/code-to-docs/通知一覧/通知一覧.csv` 行37 - 通知定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 通知メッセージは「Only idx, srt, ass and sup file types are supported.」である | E-04, E-07 | ○ |
| C-02 | AddHardcodedSubtitleFilter()メソッドで表示される | E-01, E-04 | ○ |
| C-03 | VapourSynth環境でのみ表示される | E-02 | ○ |
| C-04 | idx拡張子はcore.vsfm.VobSubフィルタを使用 | E-03 (行331) | ○ |
| C-05 | srt拡張子はcore.vsfm.TextSubModフィルタを使用 | E-03 (行333) | ○ |
| C-06 | ass拡張子はレンダラー選択ダイアログを表示 | E-05 | ○ |
| C-07 | sup拡張子はcore.sub.ImageFileフィルタを使用 | E-03 (行347) | ○ |
| C-08 | MsgError関数を使用する | E-04, E-06 | ○ |
| C-09 | TaskIcon.Errorを使用する | E-06 (行1235) | ○ |
| C-10 | showErrorMsgフラグで表示制御 | E-03 (行349) | ○ |
| C-11 | 非対応形式の場合Exit Subで終了 | E-03 (行351) | ○ |
| C-12 | AviSynth環境では別処理（No.35） | E-01 (行303-326) | ○ |
| C-13 | 同期方式で表示される | E-06 | ○ |
| C-14 | showErrorMsgフラグ付き | E-07 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張にコード根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] Project.vb の AddHardcodedSubtitleFilterメソッドを確認
- [ ] VapourSynth用の拡張子検証ロジックを確認
- [ ] ass用レンダラー選択ダイアログの動作を確認
